﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/capsrv/movie/capsrv_AlbumMovieWriteStreamDataSectionAccessor.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/capsrv/capsrv_AlbumControl.h>

namespace nn{ namespace capsrv{ namespace movie{

    nn::Result AlbumMovieWriteStreamDataSectionAccessor::Read(size_t* pOutReadSize, void* buffer, size_t size, int64_t offset, void* userData) NN_NOEXCEPT
    {
        auto pSelf = reinterpret_cast<AlbumMovieWriteStreamDataSectionAccessor*>(userData);
        return ReadDataFromAlbumMovieWriteStream(pOutReadSize, buffer, size, pSelf->handle, offset);
    }

    nn::Result AlbumMovieWriteStreamDataSectionAccessor::Write(int64_t offset, const void* buffer, size_t size, void* userData) NN_NOEXCEPT
    {
        auto pSelf = reinterpret_cast<AlbumMovieWriteStreamDataSectionAccessor*>(userData);
        return WriteDataToAlbumMovieWriteStream(pSelf->handle, offset, buffer, size);
    }

    nn::Result AlbumMovieWriteStreamDataSectionAccessor::Shrink(int64_t size, void* userData) NN_NOEXCEPT
    {
        auto pSelf = reinterpret_cast<AlbumMovieWriteStreamDataSectionAccessor*>(userData);
        return SetAlbumMovieWriteStreamDataSize(pSelf->handle, size);
    }

    MovieStreamAccessor AlbumMovieWriteStreamDataSectionAccessor::GetAccessor() NN_NOEXCEPT
    {
        MovieStreamAccessor accessor = {};
        accessor.userData = this;
        accessor.read = Read;
        accessor.write = Write;
        accessor.shrink = Shrink;
        return accessor;
    }

}}}

