﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../capsrv_ImageBuffer-module.nvnflinger.h"

namespace nn{ namespace capsrv{ namespace capture{ namespace detail{

    struct VicCopyDestinationRectangle
    {
        int left;
        int top;
        int right;
        int bottom;
    };

    struct VicCopySourceInfo
    {
        int width;
        int height;
        const NvRmSurface* pSurfaceList;
        int surfaceCount;
    };

    struct VicCopyDestinationInfo
    {
        VicCopyDestinationRectangle rectangle;
        NvRmSurface* pSurfaceList;
        int surfaceCount;
    };

    enum VicCopyFilter
    {
        VicCopyFilter_Nearest,
        VicCopyFilter_Nicest,
    };

    struct VicCopyOption
    {
        VicCopyFilter filter;
    };

    class VicOperation
    {
    public:
        static nn::Result CopyToSurface(
            ImageBuffer* pDstBuffer,
            CaptureModule* pModule,
            const VicCopyDestinationRectangle* pDstRect,
            const VicCopySourceInfo& srcInfo,
            const VicCopyOption& option
        ) NN_NOEXCEPT;

        static nn::Result CopyToSurfaceList(
            CaptureModule* pModule,
            const VicCopyDestinationInfo& dstInfo,
            const VicCopySourceInfo& srcInfo,
            const VicCopyOption& option
        ) NN_NOEXCEPT;
    };

}}}}
