﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nvrm_surface.h>
#include "../capsrv_CaptureConfig.h"

namespace nn{ namespace capsrv{ namespace capture{ namespace detail{

    static void DumpNvRmSurface(const NvRmSurface& s) NN_NOEXCEPT
    {
        NN_CAPSRV_CAPTURE_LOG_SURFACE_DUMP("  .Width =%d\n", s.Width);
        NN_CAPSRV_CAPTURE_LOG_SURFACE_DUMP("  .Height=%d\n", s.Height);
        NN_CAPSRV_CAPTURE_LOG_SURFACE_DUMP("  .ColorFormat=%u(%X)\n", static_cast<uint32_t>(s.ColorFormat), static_cast<int>(s.ColorFormat));
        NN_CAPSRV_CAPTURE_LOG_SURFACE_DUMP("  .Layout=%d\n", static_cast<int>(s.Layout));
        NN_CAPSRV_CAPTURE_LOG_SURFACE_DUMP("  .Pitch=%d\n", s.Pitch);
        NN_CAPSRV_CAPTURE_LOG_SURFACE_DUMP("  .Kind=%d\n", s.Kind);
        NN_CAPSRV_CAPTURE_LOG_SURFACE_DUMP("  .BlockHeightLog2=%d\n", s.BlockHeightLog2);
        NN_CAPSRV_CAPTURE_LOG_SURFACE_DUMP("  .DisplayScanFormat=%d\n", static_cast<int>(s.DisplayScanFormat));
        NN_CAPSRV_CAPTURE_LOG_SURFACE_DUMP("  .SecondFieldOffset=%d\n", s.SecondFieldOffset);
        NN_CAPSRV_CAPTURE_LOG_SURFACE_DUMP("  .Flags=%llu\n", s.Flags);
        NN_CAPSRV_CAPTURE_LOG_SURFACE_DUMP("  .Size=%llu\n", s.Size);
        NN_UNUSED(s);
    }

}}}}

