﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "capsrv_MemoryPool.h"

#include <nn/result/result_HandlingUtility.h>

namespace nn{ namespace capsrv{ namespace capture{

    class MemoryPoolData
    {
    public:
        typedef MemoryPool::DataType DataType;
        typedef MemoryPool::DataStorageType DataStorageType;
    public:
        static size_t GetRequiredAlignment() NN_NOEXCEPT
        {
            return 1;
        }

        static size_t GetRequiredUnitSize() NN_NOEXCEPT
        {
            return 1;
        }

        nn::Result Initialize(CaptureModule* pModule, void* pMemory, size_t size) NN_NOEXCEPT
        {
            m_pModule = pModule;
            m_pMemory = pMemory;
            m_Size    = size;
            NN_RESULT_SUCCESS;
        }

        void Finalize() NN_NOEXCEPT
        {
        }

    private:
        CaptureModule* m_pModule;
        void*          m_pMemory;
        size_t         m_Size;
    };

}}}
