﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrv_MemoryPool.h"
#include "capsrv_MemoryPool-module.stub.h"

#include <new>
#include <cstring>
#include <nn/nn_SdkAssert.h>

namespace nn{ namespace capsrv{ namespace capture{

    size_t MemoryPool::GetRequiredAlignment() NN_NOEXCEPT
    {
        return MemoryPoolData::GetRequiredAlignment();
    }

    size_t MemoryPool::GetRequiredUnitSize() NN_NOEXCEPT
    {
        return MemoryPoolData::GetRequiredUnitSize();
    }

    MemoryPool::MemoryPool() NN_NOEXCEPT
    {
        NN_CAPSRV_CAPTURE_DATASTORAGE_CHECK(DataType, m_DataStorage);
        std::memset(this, 0, sizeof(*this));
    }

    nn::Result MemoryPool::Initialize(CaptureModule* pModule, void* pMemory, size_t size) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(!IsInitialized());
        m_pData = new(&m_DataStorage) DataType();
        return m_pData->Initialize(pModule, pMemory, size);
    }

    void MemoryPool::Finalize() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        m_pData->Finalize();
        m_pData->~DataType();
        m_pData = nullptr;
    }

}}}
