﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "capsrv_ImageBuffer.h"

#include "capsrv_MemoryPool.h"
#include <nvrm_surface.h>

namespace nn{ namespace capsrv{ namespace capture{

    class ImageBufferData
    {
    public:
        typedef ImageBuffer::InfoType InfoType;
    public:
        static size_t GetRequiredMemorySize(const InfoType& info) NN_NOEXCEPT;
        static size_t GetRequiredMemoryAlignment(CaptureModule* pModule, const InfoType& info) NN_NOEXCEPT;

        nn::Result Initialize(CaptureModule* pModule, const InfoType& info, MemoryPool* pMemoryPool, ptrdiff_t offset, size_t size) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        void FlushCache() const NN_NOEXCEPT;

        int GetWidth() const NN_NOEXCEPT;
        int GetHeight() const NN_NOEXCEPT;
        ImageFormat GetImageFormat() const NN_NOEXCEPT;
        const NvRmSurface* GetSurface() const NN_NOEXCEPT;
        NvRmSurface* GetSurface() NN_NOEXCEPT;

        const MemoryPool* GetMemoryPool() const NN_NOEXCEPT;
        ptrdiff_t GetMemoryOffset() const NN_NOEXCEPT;
        size_t GetMemorySize() const NN_NOEXCEPT;

    public:
        InfoType m_Info;

        NvRmSurface m_Surface;

        MemoryPool* m_pMemoryPool;
        ptrdiff_t   m_Offset;
        size_t      m_Size;
    };

}}}
