﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "capsrv_CaptureModule.h"

#include <gui/SurfaceComposerClient.h>

#include <nvddk_vic.h>
#include <nvdc.h>

namespace nn{ namespace capsrv{ namespace capture{

    struct CaptureModuleData
    {
        // nvnflinger
        const hw_module_t*                          pModule;
        alloc_device_t*                             pGralloc;
        android::sp<android::SurfaceComposerClient> pClient;

        // VIC
        NvRmDeviceHandle vicDevice;
        NvDdkVicSession* pVicSession;
    };

    class CaptureModule
    {
    public:
        CaptureModule() NN_NOEXCEPT;
        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        alloc_device_t* GetGralloc() NN_NOEXCEPT
        {
            return m_Data.pGralloc;
        }

        android::SurfaceComposerClient* GetClinet() NN_NOEXCEPT
        {
            return m_Data.pClient.get();
        }

        NvRmDeviceHandle GetVicDevice() NN_NOEXCEPT
        {
            return m_Data.vicDevice;
        }

        NvDdkVicSession* GetVicSession() NN_NOEXCEPT
        {
            return m_Data.pVicSession;
        }

    private:
        CaptureModuleData m_Data;
    };

}}}
