﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/album/album_Applet.h>
#include <nn/album/album_AppletTypesPrivate.h>
#include <nn/la/la_Api.h>

namespace nn { namespace album {

namespace {

// CommonArgumentのバージョン指定
const int cMajorVersion = 1;
const int cMinorVersion = 0;

void SetDefaultAppletArg_( AppletArg& arg )
{
    std::memset( &arg, 0, sizeof( AppletArg ) );
}

nn::Result StartApplet_( nn::applet::LibraryAppletHandle& handle, const AppletArg& appletArg, bool isFromHomeMenu )
{
    // LAを生成する
    NN_ABORT_UNLESS_RESULT_SUCCESS( nn::applet::CreateLibraryApplet(
        &handle,
        nn::applet::AppletId_LibraryAppletPhotoViewer,
        nn::applet::LibraryAppletMode_AllForeground ) );

    // LA共通パラメータをストレージにプッシュする
    nn::la::CommonArgumentsWriter common_arg( cMajorVersion, cMinorVersion );
    common_arg.SetPlayStartupSound( isFromHomeMenu );
    common_arg.PushToInChannel( handle );

    // 引数をプッシュする
    nn::la::PushToInChannel( handle, &appletArg, sizeof( appletArg ) );

    // LA起動
    nn::Result result = nn::la::StartLibraryApplet( handle, false );

    return result;
}

void CloseApplet_( const nn::applet::LibraryAppletHandle& handle )
{
    nn::applet::CloseLibraryApplet( handle );
}

} // anonymous namespace

void ShowAlbumFiles() NN_NOEXCEPT
{
    nn::applet::LibraryAppletHandle handle = {};

    // 起動引数
    AppletArg arg;
    SetDefaultAppletArg_( arg );
    arg.mode = AppletMode_ShowAppFiles;

    // アプレットを起動する
    StartApplet_( handle, arg, false );
    CloseApplet_( handle );
}

void ShowAllAlbumFiles() NN_NOEXCEPT
{
    nn::applet::LibraryAppletHandle handle = {};

    // 起動引数
    AppletArg arg;
    SetDefaultAppletArg_( arg );
    arg.mode = AppletMode_ShowAllFiles;

    // アプレットを起動する
    StartApplet_( handle, arg, false );
    CloseApplet_( handle );
}

void ShowAllAlbumFilesForHomeMenu() NN_NOEXCEPT
{
    nn::applet::LibraryAppletHandle handle = {};

    // 起動引数
    AppletArg arg;
    SetDefaultAppletArg_( arg );
    arg.mode = AppletMode_ShowAllFilesForHomeMenu;

    // アプレットを起動する
    StartApplet_( handle, arg, true );
    CloseApplet_( handle );
}

}} // namespace nn::album
