﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/time/time_CalendarTime.h>
#include <nn/album/album_AlbumFileEntry.private.h>

#include "album_AlbumFileEntry.h"

namespace nn { namespace album {

time::CalendarTime GetAlbumFileCreatedTime(const AlbumFileEntry& entry) NN_NOEXCEPT
{
    time::CalendarTime time = {};

    // ファイルリスト取得の段階で、無効な日付情報のファイルは除外されるため、
    // 通常はここの ABORT に引っかかることはない。
    NN_ABORT_UNLESS_RESULT_SUCCESS( reinterpret_cast<const AlbumFileEntryImpl*>(&entry)->dateTime.ToCalendarTime(&time) );

    return time;
}

}}  // namespace nn::album
