﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_WINEXT_NN_OS_SYSTEMI_H_
#define NW_WINEXT_NN_OS_SYSTEMI_H_

#if _MSC_VER >= 1500
#pragma once
#endif

// #include <mmsystem.h>
//#include <EGL/egl.h>

#ifdef __cplusplus
extern "C" {
#endif


#ifdef __cplusplus
} /* extern "C" */
#endif

namespace nw {
namespace internal {
namespace winext {

/*
    アプリケーションを終了させるために送出する例外クラス
*/
class ApplicationExitException
{
public:
                        ApplicationExitException(int exitValue)
    {
        exitValue_ = exitValue;
    }

    int                 GetExitCode() const     { return exitValue_; }

private:
    int                 exitValue_;     // 終了コード
};


/*
    Windows Multimedia APIのエラーを表す例外クラス
*/
class MultimediaApiException
{
public:
                        MultimediaApiException(unsigned int result)
                        : result_(result) {}

    unsigned int            GetResultCode() const   { return result_; }

private:
    unsigned int            result_;
};

/*
    timeSetEventに失敗したことを表す例外クラス
*/
class MultimediaTimerSetEventException
{
public:
                        MultimediaTimerSetEventException() {}
};


extern unsigned short       gPadStatus;


void                Init_OS_System();

void                Finalize_OS_System();


void                InitCommandWindow();

void                CreateMainWindow();

void                DestroyMainWindw();

bool                IsCreateMainWindow();

#if 0
void                MakeCurrent(
                        EGLDisplay display,
                        EGLSurface surface,
                        EGLContext context);
#endif

}   // namespace winext {
}   // namespace internal {
}   // namespace nw


/* NW_WINEXT_NN_OS_SYSTEMI_H_ */
#endif
