﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "system.h"
#include "systemi.h"

//============================================================================
//          TERMINATE and HALT
//============================================================================

#if _MSC_VER >= 1500
#pragma warning(push)

// 警告の無効化「例外がスローされないはずなのにスローされる」
#pragma warning(disable : 4297)
#endif

static bool s_Terminating = false;
static int  s_ExitStatus;
static int  s_ExitCount;

/*---------------------------------------------------------------------------*
  Name:         OS_Exit

  Description:  Display exit string and Terminate.

  Arguments:    status  : exit status

  Returns:      --  (Never return)
 *---------------------------------------------------------------------------*/
void
OS_Exit(int status)
{
    const int FORCE_TERMINATE_COUNT = 2;
    s_ExitStatus  = status;
    s_ExitCount = FORCE_TERMINATE_COUNT;
    s_Terminating = true;
//    throw nw::internal::winext::ApplicationExitException(status);
}

/*---------------------------------------------------------------------------*
  Name:         OS_IsTerminating

  Description:  終了処理中かどうかを判定します。

  Arguments:    None.

  Returns:      終了中の場合は true、そうでない場合は false です。
 *---------------------------------------------------------------------------*/
bool
OS_IsTerminating()
{
    return s_Terminating;
}

void
OS_DoTerminate()
{
    if ( s_Terminating && --s_ExitCount <= 0 )
    {
        throw nw::internal::winext::ApplicationExitException(s_ExitStatus);
    }
}


#if _MSC_VER >= 1500
#pragma warning(pop)
#endif

