﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <winext/cafe/pad.h>
#include "../pcsdk/systemi.h"
#include <winext/cafe/os/OSInterrupt.h>

#include <stddef.h>
#include <string.h>

#include <windows.h>

static u32 EnabledBits;


namespace nw {
namespace internal {
namespace winext {

/*---------------------------------------------------------------------------*
  Name:         PAD_Init

  Description:  PADの初期化を行います。

  Arguments:    なし。

  Returns:      なし。
 *---------------------------------------------------------------------------*/
void
PADInit()
{
    EnabledBits = NW_WINEXT_PAD_CHAN0_BIT;
}

void PADRead( PADStatus* status )
{
    BOOL enabled;
    s32  chan;
    u32  chanBit;

    enabled = OSDisableInterrupts();

    for (chan = 0; chan < NW_WINEXT_PAD_MAX_CONTROLLERS; chan++, status++)
    {
        chanBit = NW_WINEXT_PAD_CHAN0_BIT >> chan;

        if (!(EnabledBits & chanBit))
        {
            status->err = (s8) NW_WINEXT_PAD_ERR_NO_CONTROLLER;
            memset(status, 0, offsetof(PADStatus, err));
            continue;
        }

        USHORT data = nw::internal::winext::gPadStatus;
        status->button = nw::internal::winext::gPadStatus;
        status->stickX = 0;
        status->stickY = 0;
        status->substickX = 0;
        status->substickY = 0;
        status->triggerLeft = 0;
        status->triggerRight = 0;
        status->analogA = 0;
        status->analogB = 0;

        status->err = NW_WINEXT_PAD_ERR_NONE;
    }

    OSRestoreInterrupts(enabled);
}

} // namespace winext
} // namespace internal
} // namespace nw
