﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_WINEXT_OSASSERT_H_
#define NW_WINEXT_OSASSERT_H_

namespace nw {
namespace internal {
namespace winext {

/*---------------------------------------------------------------------------*
    Error messages of OS.c
 *---------------------------------------------------------------------------*/
#define OS_ERR_EXCEPTIONINIT_TOOBIG         "OSExceptionInit(): too big exception vector code."
#define OS_ERR_SETEXCEPTIONHANDLER_UNKNOWN  "__OSSetExceptionHandler(): unknown exception."
#define OS_ERR_GETEXCEPTIONHANDLER_UNKNOWN  "__OSGetExceptionHandler(): unknown exception."

/*---------------------------------------------------------------------------*
    Error messages of OSAddress.c
 *---------------------------------------------------------------------------*/
#define OS_ERR_PHYSICALTOEFFECTIVE_INVADDR  "OSPhysicalToEffective(): illegal address."
#define OS_ERR_EFFECTIVETOPHYSICAL_INVADDR  "OSEffectiveToPhysical(): illegal address."

/*---------------------------------------------------------------------------*
    Error messages of OSAlarm.c
 *---------------------------------------------------------------------------*/
#define OS_ERR_SETALARM_TICK                "OSSetAlarm(): tick was less than zero."
#define OS_ERR_SETALARM_HANDLER             "OSSetAlarm(): null handler was specified."
#define OS_ERR_SETABSALARM_HANDLER          "OSSetAbsAlarm(): null handler was specified."
#define OS_ERR_SETPERIODICALARM_PERIOD      "OSSetPeriodicAlarm(): period was less than zero."
#define OS_ERR_SETPERIODICALARM_HANDLER     "OSSetPeriodicAlarm(): null handler was specified."
#define OS_ERR_CANCELALARMS_INVTAG          "OSCancelAlarms(): invalid tag. (this tag is used by the operating system.)"

/*---------------------------------------------------------------------------*
    Error messages of OSAlloc.c
 *---------------------------------------------------------------------------*/
#define OS_ERR_ALLOCFROMHEAP_NOHEAP         "OSAllocFromHeap(): heap is not initialized."
#define OS_ERR_ALLOCFROMHEAP_INVSIZE        "OSAllocFromHeap(): invalid size."
#define OS_ERR_ALLOCFROMHEAP_INVHEAP        "OSAllocFromHeap(): invalid heap handle."
#define OS_ERR_ALLOCFROMHEAP_BROKENHEAP     "OSAllocFromHeap(): heap is broken."
#define OS_ERR_ALLOCFIXED_NOHEAP            "OSAllocFixed(): heap is not initialized."
#define OS_ERR_ALLOCFIXED_INVRANGE          "OSAllocFixed(): invalid range."
#define OS_ERR_FREETOHEAP_NOHEAP            "OSFreeToHeap(): heap is not initialized."
#define OS_ERR_FREETOHEAP_INVPTR            "OSFreeToHeap(): invalid pointer."
#define OS_ERR_FREETOHEAP_INVHEAP           "OSFreeToHeap(): invalid heap handle."
#define OS_ERR_SETCURRENTHEAP_NOHEAP        "OSSetCurrentHeap(): heap is not initialized."
#define OS_ERR_SETCURRENTHEAP_INVHEAP       "OSSetCurrentHeap(): invalid heap handle."
#define OS_ERR_INITALLOC_INVNUMHEAPS        "OSInitAlloc(): invalid number of heaps."
#define OS_ERR_INITALLOC_INVRANGE           "OSInitAlloc(): invalid range."
#define OS_ERR_INITALLOC_INSRANGE           "OSInitAlloc(): too small range."
#define OS_ERR_CREATEHEAP_NOHEAP            "OSCreateHeap(): heap is not initialized."
#define OS_ERR_CREATEHEAP_INVRANGE          "OSCreateHeap(): invalid range."
#define OS_ERR_CREATEHEAP_INSRANGE          "OSCreateHeap(): too small range."
#define OS_ERR_DESTROYHEAP_NOHEAP           "OSDestroyHeap(): heap is not initialized."
#define OS_ERR_DESTROYHEAP_INVHEAP          "OSDestroyHeap(): invalid heap handle."
#define OS_ERR_ADDTOHEAP_NOHEAP             "OSAddToHeap(): heap is not initialized."
#define OS_ERR_ADDTOHEAP_INVHEAP            "OSAddToHeap(): invalid heap handle."
#define OS_ERR_ADDTOHEAP_INVRANGE           "OSAddToHeap(): invalid range."
#define OS_ERR_ADDTOHEAP_INSRANGE           "OSAddToHeap(): too small range."
#define OS_ERR_REFERENT_NOHEAP              "OSReferentSize(): heap is not initialized."
#define OS_ERR_REFERENT_INVPTR              "OSReferentSize(): invalid pointer."
#define OS_ERR_DUMPHEAP_NOHEAP              "OSDumpHeap(): heap is not initialized."
#define OS_ERR_DUMPHEAP_INVHEAP             "OSDumpHeap(): invalid heap handle."
#define OS_ERR_DUMPHEAP_BROKENHEAP          "OSDumpHeap(): heap is broken."

/*---------------------------------------------------------------------------*
    Error messages of OSArena.c
 *---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
    Error messages of OSAudioSystem.c
 *---------------------------------------------------------------------------*/
#define OS_ERR_INITAUDIOSYSTEM_ARAMDMAPROGRESS  "__OSInitAudioSystem(): ARAM DMA already in progress"
#define OS_ERR_INITAUDIOSYSTEM_DSPDMAPROGRESS   "__OSInitAudioSystem(): DSP DMA already in progress"
#define OS_ERR_INITAUDIOSYSTEM_DSPWORKING       "__OSInitAudioSystem(): DSP already working"
#define OS_ERR_INITAUDIOSYSTEM_INVALIDMSG       "__OSInitAudioSystem(): DSP returns invalid message"

/*---------------------------------------------------------------------------*
    Error messages of OSError.c
 *---------------------------------------------------------------------------*/
#define OS_ERR_SETERRORHANDLER_INVERR       "OSSetErrorHandler(): unknown error."

/*---------------------------------------------------------------------------*
    Error messages of OSInterrupt.c
 *---------------------------------------------------------------------------*/
#define OS_ERR_SETINTERRUPTHANDLER_UNKNOWN  "__OSSetInterruptHandler(): unknown interrupt."
#define OS_ERR_GETINTERRUPTHANDLER_UNKNOWN  "__OSGetInterruptHandler(): unknown interrupt."
#define OS_ERR_SETINTERRUPTHANDLER_INVALID  "__OSSetInterruptHandler(): invalid interrupt specified."

/*---------------------------------------------------------------------------*
    Error messages of OSSerial.c
 *---------------------------------------------------------------------------*/
#define SI_ERR_TRANSFER_INVCHAN             "SITransfer(): invalid channel."
#define SI_ERR_TRANSFER_INVOUTBYTES         "SITransfer(): output size is out of range (must be 1 to 128)."
#define SI_ERR_TRANSFER_INVINBYTES          "SITransfer(): input size is out of range (must be 1 to 128)."
#define SI_ERR_SYNC_CALLBACK                "SISync(): asynchronous SITransfer() is in progress."
#define SI_ERR_SYNC_NOTRANSFER              "SISync(): no SITransfer() is in progress."
#define SI_ERR_SETCOMMAND_INVCHAN           "SISetCommand(): invalid channel."
#define SI_ERR_GETCOMMAND_INVCHAN           "SIGetCommand(): invalid channel."
#define SI_ERR_SETXY_INVX                   "SISetXY(): x is out of range (8 <= x <= 1023)."
#define SI_ERR_SETXY_INVY                   "SISetXY(): y is out of range (0 <= y <= 255)."
#define SI_ERR_GETRESPONSE_INVCHAN          "SIGetResponse(): invalid channel."
#define SI_ERR_ENABLEPOLLING_INVCHAN        "SIEnablePolling(): invalid chan bit(s)."
#define SI_ERR_DISABLEPOLLING_INVCHAN       "SIDisablePolling(): invalid chan bit(s)."

/*---------------------------------------------------------------------------*
    Error messages of OSThread.c
 *---------------------------------------------------------------------------*/
#define OS_ERR_CREATETHREAD_BADPRIO         "OSCreateThread(): priority out of range (0 <= priority <= 31)."
#define OS_ERR_CREATETHREAD_STILLACTIVE     "OSCreateThread(): thread %p is still active."
#define OS_ERR_EXITTHREAD_NOCURRENT         "OSExitThread(): current thread does not exist."
#define OS_ERR_EXITTHREAD_NOTRUNNING        "OSExitThread(): current thread is not running."
#define OS_ERR_EXITTHREAD_NOTACTIVE         "OSExitThread(): current thread is not active."
#define OS_ERR_CANCELTHREAD_NOTACTIVE       "OSExitThread(): thread %p is not active."
#define OS_ERR_JOINTHREAD_NOTACTIVE         "OSJoinThread(): thread %p is not active."
#define OS_ERR_DETACHTHREAD_NOTACTIVE       "OSDetachThread(): thread %p is not active."
#define OS_ERR_RESUMETHREAD_NOTACTIVE       "OSResumeThread(): thread %p is not active."
#define OS_ERR_RESUMETHREAD_MORIBUND        "OSResumeThread(): thread %p is terminated."
#define OS_ERR_SUSPENDTHREAD_NOTACTIVE      "SuspendThread(): thread %p is not active."
#define OS_ERR_SUSPENDTHREAD_MORIBUND       "SuspendThread(): thread %p is terminated."
#define OS_ERR_SLEEPTHREAD_NOCURRENT        "OSSleepThread(): current thread does not exist."
#define OS_ERR_SLEEPTHREAD_NOTACTIVE        "OSSleepThread(): current thread %p is not active."
#define OS_ERR_SLEEPTHREAD_NOTRUNNING       "OSSleepThread(): current thread %p is not running."
#define OS_ERR_SLEEPTHREAD_SUSPENDED        "OSSleepThread(): current thread %p is suspended."
#define OS_ERR_SETTHREADPRIORITY_BADPRIO    "OSSetThreadPriority(): priority out of range (0 <= priority <= 31)."
#define OS_ERR_SETTHREADPRIORITY_NOTACTIVE  "OSSetThreadPriority(): thread %p is not active."
#define OS_ERR_SETTHREADPRIORITY_MORIBUND   "OSSetThreadPriority(): thread %p is terminated."
#define OS_ERR_MUST_ACQUIRE_SCHEDULER_LOCK  "%s(): called without acquiring the scheduler lock."

/*---------------------------------------------------------------------------*
    Error messages of OSTimer.c
 *---------------------------------------------------------------------------*/
#define OS_ERR_SETTIMERCALLBACK_INIT        "OSSetTimerCallback(): timer is not initialized."
#define OS_ERR_INITTIMER_INVTIME            "OSInitTimer(): time param must be less than 0x80000000."
#define OS_ERR_STARTTIMER_INIT              "OSStartTimer(): timer is not initialized."
#define OS_ERR_STOPTIMER_INIT               "OSStopTimer(): timer is not initialized."

/*---------------------------------------------------------------------------*
    Error messages of OSMutex.c
 *---------------------------------------------------------------------------*/
#define OS_ERR_LOCKMUTEX_NOCURRENT          "OSLockMutex(): current thread does not exist."
#define OS_ERR_LOCKMUTEX_NOTRUNNING         "OSLockMutex(): current thread is not running."
#define OS_ERR_LOCKMUTEX_DEADLOCK           "OSLockMutex(): detected deadlock: current thread %p, mutex %p."
#define OS_ERR_UNLOCKMUTEX_NOCURRENT        "OSUnlockMutex(): current thread does not exist."
#define OS_ERR_UNLOCKMUTEX_NOTRUNNING       "OSUnlockMutex(): current thread is not running."
#define OS_ERR_UNLOCKMUTEX_NOTOWNER         "OSUnlockMutex(): current thread %p is not the owner of mutex %p."
#define OS_ERR_TRYLOCKMUTEX_NOCURRENT       "OSTryLockMutex(): current thread does not exist."
#define OS_ERR_TRYLOCKMUTEX_NOTRUNNING      "OSTryLockMutex(): current thread is not running."
#define OS_ERR_WAITCOND_NOCURRENT           "OSWaitCond(): current thread does not exist."
#define OS_ERR_WAITCOND_NOTRUNNING          "OSWaitCond(): current thread is not running."
#define OS_ERR_WAITCOND_NOTOWNER            "OSWaitCond(): current thread %p is not the owner of mutex %p."

/*---------------------------------------------------------------------------*
    Locked cache error messages
 *---------------------------------------------------------------------------*/
#define LC_ERR_ALLOC_ADDR                   "LCAlloc(): addr must be 32 byte aligned"
#define LC_ERR_ALLOC_NBYTES                 "LCAlloc(): nBytes must be 32 byte aligned"
#define LC_ERR_ALLOCNF_ADDR                 "LCAllocNoFlush(): addr must be 32 byte aligned"
#define LC_ERR_ALLOCNF_NBYTES               "LCAllocNoFlush(): nBytes must be 32 byte aligned"

#define LC_ERR_FREE_ADDR                    "LCFree(): addr must be 32 byte aligned"
#define LC_ERR_FREE_NBYTES                  "LCFree(): nBytes must be 32 byte aligned"

#define LC_ERR_LOAD_SRCADDR                 "LCLoadData(): srcAddr not 32 byte aligned"
#define LC_ERR_LOAD_DESTADDR                "LCLoadData(): destAddr not 32 byte aligned"
#define LC_ERR_LOAD_NBYTES                  "LCLoadData(): nBytes not 32 byte aligned"

#define LC_ERR_STORE_SRCADDR                "LCStoreData(): srcAddr not 32 byte aligned"
#define LC_ERR_STORE_DESTADDR               "LCStoreData(): destAddr not 32 byte aligned"
#define LC_ERR_STORE_NBYTES                 "LCStoreData(): nBytes not 32 byte aligned"


} // namespace winext
} // namespace internal
} // namespace nw

#endif  // NW_WINEXT_OSASSERT_H_
