﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#if defined(__APPLE__)
#include <TargetConditionals.h>
#endif

#if defined(_WIN32)
#include <Windows.h>
#elif defined(ANDROID)
#include <cstdlib>
#elif TARGET_OS_IPHONE
#include <memory>
#include <cstdlib>
#endif


#include "AXPrivate.h"

namespace nw {
namespace internal {
namespace winext {

/*---------------------------------------------------------------------------*
    local vars
 *---------------------------------------------------------------------------*/

//          static AXSPB      __AXStudio ATTRIBUTE_ALIGN(32);
ALIGNED_VAR(static AXSPB, PPC_IO_BUFFER_ALIGN, __AXStudio);

static   s32 __AXSpbTv[AX_MAX_NUM_TVS][AX_MAX_NUM_BUSES][AX_MAX_NUM_TV_CHS];
static   s32 __AXSpbDRC[AX_MAX_NUM_DRCS][AX_MAX_NUM_BUSES][AX_MAX_NUM_DRC_CHS];
static   s32 __AXSpbRmt[AX_MAX_NUM_RMTS][AX_MAX_NUM_BUSES][AX_MAX_NUM_RMT_CHS];

/*---------------------------------------------------------------------------*
 *---------------------------------------------------------------------------*/
u32 __AXGetStudio(void)
{
    return (u32)&__AXStudio;
}


/*---------------------------------------------------------------------------*
 *---------------------------------------------------------------------------*/
void __AXDepopFadeMain(s32 *hostSum, AXSPB_STUDIO_CH *studio, s32 duration)
{
    s32 frames;

    frames   = *hostSum / duration;

    if (frames) // if we have less than "delta" cannot depop
    {
        s32 delta = *hostSum / duration;

        if (delta > 20)     delta = 20;
        if (delta < -20)    delta = -20;

        studio->dpopVal =   *hostSum;
        *hostSum            -=  delta * duration;
        studio->dpopDelta =   (s16)(delta * -1);

    }
    else
    {
        *hostSum        = 0;
        studio->dpopVal = 0;
        studio->dpopDelta   = 0;
    }
}


/*---------------------------------------------------------------------------*
 * Function: __AXPrintStudio
 * Arguments: None
 *            Uses the global variables __AXSpb* and __AXStudio
 *  This function is called for each frame. This initializes the __AXStudio
 *  from __AXSpb*. Renderers will use __AXStudio to ramp the samples to zero
 *---------------------------------------------------------------------------*/
// why the heck is this called PrintStudio??
void __AXPrintStudio(void)
{
    // print the studio param block
       u16 busCnt, chCnt, deviceCnt;

    // do TV studio

    for(deviceCnt = 0 ; deviceCnt < AX_MAX_NUM_TVS; deviceCnt++)
    {
        for(busCnt =0; busCnt < AX_MAX_NUM_BUSES; busCnt++)
        {
            for(chCnt=0; chCnt< AX_MAX_NUM_TV_CHS; chCnt++)
            {
                __AXDepopFadeMain(&__AXSpbTv[deviceCnt][busCnt][chCnt],
                                  &__AXStudio.tvStudio[deviceCnt][busCnt][chCnt],
                                  AX_IN_SAMPLES_PER_FRAME);
            } // chCnt
        } // busCnt
    }// device Cnt


    // do TV studio

    for(deviceCnt = 0 ; deviceCnt < AX_MAX_NUM_DRCS; deviceCnt++)
    {
        for(busCnt =0; busCnt < AX_MAX_NUM_BUSES; busCnt++)
        {
            for(chCnt=0; chCnt< AX_MAX_NUM_DRC_CHS; chCnt++)
            {
                __AXDepopFadeMain(&__AXSpbDRC[deviceCnt][busCnt][chCnt],
                                  &__AXStudio.drcStudio[deviceCnt][busCnt][chCnt],
                                  AX_IN_SAMPLES_PER_FRAME);
            } // chCnt
        } // busCnt
    }// device Cnt



    // do TV studio

    for(deviceCnt = 0 ; deviceCnt < AX_MAX_NUM_RMTS; deviceCnt++)
    {
        for(busCnt =0; busCnt < AX_MAX_NUM_BUSES; busCnt++)
        {
            for(chCnt=0; chCnt< AX_MAX_NUM_RMT_CHS; chCnt++)
            {
                __AXDepopFadeMain(&__AXSpbRmt[deviceCnt][busCnt][chCnt],
                                  &__AXStudio.rmtStudio[deviceCnt][busCnt][chCnt],
                                  AX_RMT_SAMPLES_PER_FRAME);
            } // chCnt
        } // busCnt
    }// device Cnt

    // lets flush the cache to the RAM
//    DCFlushRange(&__AXStudio, sizeof(AXSPB));
}


/*---------------------------------------------------------------------------*
 *---------------------------------------------------------------------------*/
void __AXSPBInit(void)
{
#ifdef _DEBUG
    OSReport("Initializing AXSPB code module\n");
#endif

    u16 busCnt, chCnt, deviceCnt;

    // zero out TV studio first
    //

    //OSReport("size of AXStudio Struct: %u\n", sizeof(AXSPB_STUDIO_CH));
    //OSReport("size of AXSPB Struct: %u\n", sizeof(AXSPB));
    //OSReport("size of AXStudio Arrays: %u\n", sizeof(__AXSpbTv)+sizeof(__AXSpbDRC)+sizeof(__AXSpbRmt));

    for(deviceCnt = 0 ; deviceCnt < AX_MAX_NUM_TVS; deviceCnt++)
    {
        for(busCnt =0; busCnt < AX_MAX_NUM_BUSES; busCnt++)
        {
            for(chCnt=0; chCnt< AX_MAX_NUM_TV_CHS; chCnt++)
            {
                __AXSpbTv[deviceCnt][busCnt][chCnt] = 0;
            } // chCnt
        } // busCnt
    }// device Cnt


    // zero out DRC studio

    for(deviceCnt = 0 ; deviceCnt < AX_MAX_NUM_DRCS; deviceCnt++)
    {
        for(busCnt =0; busCnt < AX_MAX_NUM_BUSES; busCnt++)
        {
            for(chCnt=0; chCnt< AX_MAX_NUM_DRC_CHS; chCnt++)
            {
                __AXSpbDRC[deviceCnt][busCnt][chCnt] = 0;
            } // chCnt
        } // busCnt
    }// device Cnt



    // zero out RMT studio

    for(deviceCnt = 0 ; deviceCnt < AX_MAX_NUM_RMTS; deviceCnt++)
    {
        for(busCnt =0; busCnt < AX_MAX_NUM_BUSES; busCnt++)
        {
            for(chCnt=0; chCnt< AX_MAX_NUM_RMT_CHS; chCnt++)
            {
                __AXSpbRmt[deviceCnt][busCnt][chCnt] = 0;
            } // chCnt
        } // busCnt
    }// device Cnt


    memset((void*) &__AXStudio, 0, sizeof(__AXStudio));


    return;
} // end of _AXSPBInit()


/*---------------------------------------------------------------------------*
 *---------------------------------------------------------------------------*/
void __AXSPBQuit(void)
{
#ifdef _DEBUG
    OSReport("Shutting down AXSPB code module\n");
#endif
}


/*---------------------------------------------------------------------------*
 * Function: __AXDepopVoice
 * Arguments:
 *          AXPB *p     : (in) pointer to the voice to be dpoped
 *
 *   This function is called for each of the voice that stopped playing in
 *   this frame. The last sample value of the voice is added to the studio value
 *   The last sample is in s16 format, to studio is also in s32Q0 format
 *---------------------------------------------------------------------------*/
void __AXDepopVoice(AXPB *p)
{
    u16 busCnt, chCnt, deviceCnt;


    // do the TV dpop
    for(deviceCnt = 0 ; deviceCnt < AX_MAX_NUM_TVS; deviceCnt++)
    {
        for(busCnt =0; busCnt < AX_MAX_NUM_BUSES; busCnt++)
        {
            for(chCnt=0; chCnt< AX_MAX_NUM_TV_CHS; chCnt++)
            {
                __AXSpbTv[deviceCnt][busCnt][chCnt] += p->tvDpop[deviceCnt][busCnt][chCnt];
            } // chCnt
        } // busCnt
    }// device Cnt


    // do the DRC dpop

    for(deviceCnt = 0 ; deviceCnt < AX_MAX_NUM_DRCS; deviceCnt++)
    {
        for(busCnt =0; busCnt < AX_MAX_NUM_BUSES; busCnt++)
        {
            for(chCnt=0; chCnt< AX_MAX_NUM_DRC_CHS; chCnt++)
            {
                __AXSpbDRC[deviceCnt][busCnt][chCnt] += p->drcDpop[deviceCnt][busCnt][chCnt];
            } // chCnt
        } // busCnt
    }// device Cnt



    // do the RMT dpop

    for(deviceCnt = 0 ; deviceCnt < AX_MAX_NUM_RMTS; deviceCnt++)
    {
        for(busCnt =0; busCnt < AX_MAX_NUM_BUSES; busCnt++)
        {
            for(chCnt=0; chCnt< AX_MAX_NUM_RMT_CHS; chCnt++)
            {
                __AXSpbRmt[deviceCnt][busCnt][chCnt] += p->rmtDpop[deviceCnt][busCnt][chCnt];
            } // chCnt
        } // busCnt
    }// device Cnt

    return;

} // end of _AXDepopVoice()

} // namespace winext
} // namespace internal
} // namespace nw
