﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef   __AXRENDER_COSTS_H_INC__
#define   __AXRENDER_COSTS_H_INC__

#include<winext/cafe/ax.h>

namespace nw {
    namespace internal {
        namespace winext {

/*************************************************************
 Still need to generate real values for these stats:
 *************************************************************/
#define   AX_COST_AUX_STAGE_IDLE 0.1
#define   DSP_COST_AUX_STAGE_IDLE 0.5
#define   AX_COST_FINAL_STAGE 2.0
#define   DSP_COST_FINAL_STAGE 4.0
#define   AX_COST_AUX_STAGE_RVB 5.0
/*************************************************************/

#define AX_COST_PPC_MIX_IDLE (0.578)
#define AX_COST_DSP_MIX_IDLE (14.831)
#define AX_COST_PPC_POST_MIX_IDLE (4.982)
#define AX_COST_OUTPUT_STAGE_IDLE (14.067)
#define AX_COST_DSP_PCM16_VOICE 0.000
#define AX_COST_DSP_PCM8_VOICE 0.000
#define AX_COST_DSP_ADPCM_VOICE 0.000
#define AX_COST_PPC_PCM16_VOICE 0.148
#define AX_COST_PPC_ADPCM_VOICE 0.212
#define AX_COST_PPC_PCM8_VOICE 0.148
extern f32 __AXCostSrcRatio[];
#define MAX_SRC_RATIO_ENTRIES (16)
extern f32 __AXCostDspSrc[AX_SRC_TYPE_4TAP_16K+1][MAX_SRC_RATIO_ENTRIES];
extern f32 __AXCostPpcSrc[AX_SRC_TYPE_4TAP_16K+1][MAX_SRC_RATIO_ENTRIES];
#define AX_COST_DSP_BIQUAD (0.336)
#define AX_COST_PPC_BIQUAD (0.190)
#define AX_COST_DSP_LPF (0.114)
#define AX_COST_PPC_LPF (0.101)
#define AX_COST_DSP_MIX_PER_CH (0.192)
#define AX_COST_PPC_MIX_PER_CH (0.021)
#define AX_COST_COMPRESSOR_PER_CH (0.020)

        } // namespace winext
    } // namespace internal
} // namespace nw

#endif // __AXRENDER_COSTS_H_INC__

