﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <math.h>
#include <winext/cafe/os.h>
#include <winext/cafe/ax.h>
#include "AXPrivate.h"

namespace nw {
namespace internal {
namespace winext {

static u32              __AXDeviceCompressorSwitch[AX_MAX_NUM_DEVICES];
static u16*              __AXDeviceCompressorTable[AX_MAX_NUM_DEVICES];
static u16              __AXDeviceCompReleaseFrames[AX_MAX_NUM_DEVICES];

// compressor related functions & variables
static u32 __AXTVCompState[AX_MAX_NUM_TVS];
static u32 __AXDRCCompState[AX_MAX_NUM_DRCS];
static u32 __AXRMTCompState[AX_MAX_NUM_RMTS];
/*
    These are volume tables used by the compressor. These include:

    * 10 attack envelopes used based on state of compressor
    * 1 release envelope in 10 satges

    The attack is 1 audio frame and release is 10 frames for time of...
    3ms and 30ms respectively.

    The DSP code will generate an offset for this table to DMA into memory
    based on it's state.
*/

#ifdef __COMPRESSOR_32KHZ__
ALIGNED_VAR(u16, PPC_IO_BUFFER_ALIGN, __AXCompressorDefaultTable[2016] = {)
// attack env 0,  0.000000dB to -4.000000dB, delta -0.041667dB/sample
0x7f63, 0x7ec7, 0x7e2b, 0x7d91, 0x7cf7, 0x7c5e, 0x7bc5, 0x7b2e,
0x7a97, 0x7a01, 0x796b, 0x78d6, 0x7842, 0x77af, 0x771c, 0x768b,
0x75f9, 0x7569, 0x74d9, 0x744a, 0x73bb, 0x732e, 0x72a0, 0x7214,
0x7188, 0x70fd, 0x7073, 0x6fe9, 0x6f60, 0x6ed7, 0x6e50, 0x6dc8,
0x6d42, 0x6cbc, 0x6c37, 0x6bb2, 0x6b2e, 0x6aab, 0x6a28, 0x69a6,
0x6925, 0x68a4, 0x6824, 0x67a4, 0x6725, 0x66a7, 0x6629, 0x65ac,
0x652f, 0x64b4, 0x6438, 0x63bd, 0x6343, 0x62ca, 0x6251, 0x61d8,
0x6160, 0x60e9, 0x6072, 0x5ffc, 0x5f86, 0x5f11, 0x5e9d, 0x5e29,
0x5db6, 0x5d43, 0x5cd1, 0x5c5f, 0x5bee, 0x5b7d, 0x5b0d, 0x5a9d,
0x5a2e, 0x59c0, 0x5952, 0x58e5, 0x5878, 0x580b, 0x579f, 0x5734,
0x56c9, 0x565f, 0x55f5, 0x558c, 0x5523, 0x54bb, 0x5453, 0x53ec,
0x5385, 0x531e, 0x52b9, 0x5253, 0x51ee, 0x518a, 0x5126, 0x50c3,
// attack env 1, -0.400000dB to -4.000000dB, delta -0.037500dB/sample
0x79b6, 0x7930, 0x78aa, 0x7825, 0x77a0, 0x771c, 0x7699, 0x7616,
0x7594, 0x7512, 0x7491, 0x7411, 0x7391, 0x7311, 0x7292, 0x7214,
0x7196, 0x7119, 0x709c, 0x7020, 0x6fa4, 0x6f29, 0x6eaf, 0x6e35,
0x6dbb, 0x6d42, 0x6cc9, 0x6c52, 0x6bda, 0x6b63, 0x6aed, 0x6a77,
0x6a01, 0x698c, 0x6918, 0x68a4, 0x6831, 0x67be, 0x674b, 0x66d9,
0x6668, 0x65f7, 0x6587, 0x6517, 0x64a7, 0x6438, 0x63ca, 0x635c,
0x62ee, 0x6281, 0x6214, 0x61a8, 0x613c, 0x60d1, 0x6066, 0x5ffc,
0x5f92, 0x5f29, 0x5ec0, 0x5e57, 0x5def, 0x5d88, 0x5d21, 0x5cba,
0x5c54, 0x5bee, 0x5b88, 0x5b23, 0x5abf, 0x5a5b, 0x59f7, 0x5994,
0x5931, 0x58cf, 0x586d, 0x580b, 0x57aa, 0x574a, 0x56e9, 0x5689,
0x562a, 0x55cb, 0x556c, 0x550e, 0x54b0, 0x5453, 0x53f6, 0x5399,
0x533d, 0x52e1, 0x5286, 0x522b, 0x51d0, 0x5176, 0x511c, 0x50c3,
// attack env 2, -0.800000dB to -4.000000dB, delta -0.033333dB/sample
0x744a, 0x73d8, 0x7366, 0x72f5, 0x7284, 0x7214, 0x71a4, 0x7135,
0x70c6, 0x7057, 0x6fe9, 0x6f7b, 0x6f0e, 0x6ea1, 0x6e35, 0x6dc8,
0x6d5d, 0x6cf2, 0x6c87, 0x6c1c, 0x6bb2, 0x6b49, 0x6ae0, 0x6a77,
0x6a0e, 0x69a6, 0x693f, 0x68d8, 0x6871, 0x680a, 0x67a4, 0x673f,
0x66d9, 0x6675, 0x6610, 0x65ac, 0x6548, 0x64e5, 0x6482, 0x6420,
0x63bd, 0x635c, 0x62fa, 0x6299, 0x6238, 0x61d8, 0x6178, 0x6119,
0x60b9, 0x605b, 0x5ffc, 0x5f9e, 0x5f40, 0x5ee3, 0x5e86, 0x5e29,
0x5dcd, 0x5d71, 0x5d15, 0x5cba, 0x5c5f, 0x5c04, 0x5baa, 0x5b50,
0x5af7, 0x5a9d, 0x5a45, 0x59ec, 0x5994, 0x593c, 0x58e5, 0x588d,
0x5837, 0x57e0, 0x578a, 0x5734, 0x56df, 0x5689, 0x5635, 0x55e0,
0x558c, 0x5538, 0x54e4, 0x5491, 0x543e, 0x53ec, 0x5399, 0x5347,
0x52f6, 0x52a4, 0x5253, 0x5203, 0x51b2, 0x5162, 0x5112, 0x50c3,
// attack env 3, -1.200000dB to -4.000000dB, delta -0.029167dB/sample
0x6f1c, 0x6ebc, 0x6e5d, 0x6dfe, 0x6da0, 0x6d42, 0x6ce4, 0x6c87,
0x6c2a, 0x6bcd, 0x6b70, 0x6b14, 0x6ab8, 0x6a5d, 0x6a01, 0x69a6,
0x694c, 0x68f1, 0x6897, 0x683d, 0x67e4, 0x678b, 0x6732, 0x66d9,
0x6681, 0x6629, 0x65d2, 0x657a, 0x6523, 0x64cc, 0x6476, 0x6420,
0x63ca, 0x6374, 0x631f, 0x62ca, 0x6275, 0x6220, 0x61cc, 0x6178,
0x6124, 0x60d1, 0x607e, 0x602b, 0x5fd9, 0x5f86, 0x5f34, 0x5ee3,
0x5e91, 0x5e40, 0x5def, 0x5d9f, 0x5d4e, 0x5cfe, 0x5cae, 0x5c5f,
0x5c10, 0x5bc1, 0x5b72, 0x5b23, 0x5ad5, 0x5a87, 0x5a3a, 0x59ec,
0x599f, 0x5952, 0x5905, 0x58b9, 0x586d, 0x5821, 0x57d5, 0x578a,
0x573f, 0x56f4, 0x56a9, 0x565f, 0x5615, 0x55cb, 0x5581, 0x5538,
0x54ef, 0x54a6, 0x545d, 0x5415, 0x53cd, 0x5385, 0x533d, 0x52f6,
0x52ae, 0x5267, 0x5221, 0x51da, 0x5194, 0x514e, 0x5108, 0x50c3,
// attack env 4, -1.600000dB to -4.000000dB, delta -0.025000dB/sample
0x6a28, 0x69da, 0x698c, 0x693f, 0x68f1, 0x68a4, 0x6857, 0x680a,
0x67be, 0x6771, 0x6725, 0x66d9, 0x668e, 0x6642, 0x65f7, 0x65ac,
0x6561, 0x6517, 0x64cc, 0x6482, 0x6438, 0x63ee, 0x63a5, 0x635c,
0x6312, 0x62ca, 0x6281, 0x6238, 0x61f0, 0x61a8, 0x6160, 0x6119,
0x60d1, 0x608a, 0x6043, 0x5ffc, 0x5fb5, 0x5f6f, 0x5f29, 0x5ee3,
0x5e9d, 0x5e57, 0x5e12, 0x5dcd, 0x5d88, 0x5d43, 0x5cfe, 0x5cba,
0x5c76, 0x5c32, 0x5bee, 0x5baa, 0x5b67, 0x5b23, 0x5ae0, 0x5a9d,
0x5a5b, 0x5a18, 0x59d6, 0x5994, 0x5952, 0x5910, 0x58cf, 0x588d,
0x584c, 0x580b, 0x57cb, 0x578a, 0x574a, 0x5709, 0x56c9, 0x5689,
0x564a, 0x560a, 0x55cb, 0x558c, 0x554d, 0x550e, 0x54d0, 0x5491,
0x5453, 0x5415, 0x53d7, 0x5399, 0x535c, 0x531e, 0x52e1, 0x52a4,
0x5267, 0x522b, 0x51ee, 0x51b2, 0x5176, 0x513a, 0x50fe, 0x50c3,
// attack env 5, -2.000000dB to -4.000000dB, delta -0.020833dB/sample
0x656e, 0x652f, 0x64f1, 0x64b4, 0x6476, 0x6438, 0x63fb, 0x63bd,
0x6380, 0x6343, 0x6306, 0x62ca, 0x628d, 0x6251, 0x6214, 0x61d8,
0x619c, 0x6160, 0x6124, 0x60e9, 0x60ad, 0x6072, 0x6037, 0x5ffc,
0x5fc1, 0x5f86, 0x5f4c, 0x5f11, 0x5ed7, 0x5e9d, 0x5e63, 0x5e29,
0x5def, 0x5db6, 0x5d7c, 0x5d43, 0x5d0a, 0x5cd1, 0x5c98, 0x5c5f,
0x5c26, 0x5bee, 0x5bb5, 0x5b7d, 0x5b45, 0x5b0d, 0x5ad5, 0x5a9d,
0x5a66, 0x5a2e, 0x59f7, 0x59c0, 0x5989, 0x5952, 0x591b, 0x58e5,
0x58ae, 0x5878, 0x5841, 0x580b, 0x57d5, 0x579f, 0x576a, 0x5734,
0x56ff, 0x56c9, 0x5694, 0x565f, 0x562a, 0x55f5, 0x55c0, 0x558c,
0x5557, 0x5523, 0x54ef, 0x54bb, 0x5487, 0x5453, 0x541f, 0x53ec,
0x53b8, 0x5385, 0x5352, 0x531e, 0x52eb, 0x52b9, 0x5286, 0x5253,
0x5221, 0x51ee, 0x51bc, 0x518a, 0x5158, 0x5126, 0x50f4, 0x50c3,
// attack env 6, -2.400000dB to -4.000000dB, delta -0.016667dB/sample
0x60e9, 0x60b9, 0x608a, 0x605b, 0x602b, 0x5ffc, 0x5fcd, 0x5f9e,
0x5f6f, 0x5f40, 0x5f11, 0x5ee3, 0x5eb4, 0x5e86, 0x5e57, 0x5e29,
0x5dfb, 0x5dcd, 0x5d9f, 0x5d71, 0x5d43, 0x5d15, 0x5ce7, 0x5cba,
0x5c8c, 0x5c5f, 0x5c32, 0x5c04, 0x5bd7, 0x5baa, 0x5b7d, 0x5b50,
0x5b23, 0x5af7, 0x5aca, 0x5a9d, 0x5a71, 0x5a45, 0x5a18, 0x59ec,
0x59c0, 0x5994, 0x5968, 0x593c, 0x5910, 0x58e5, 0x58b9, 0x588d,
0x5862, 0x5837, 0x580b, 0x57e0, 0x57b5, 0x578a, 0x575f, 0x5734,
0x5709, 0x56df, 0x56b4, 0x5689, 0x565f, 0x5635, 0x560a, 0x55e0,
0x55b6, 0x558c, 0x5562, 0x5538, 0x550e, 0x54e4, 0x54bb, 0x5491,
0x5468, 0x543e, 0x5415, 0x53ec, 0x53c2, 0x5399, 0x5370, 0x5347,
0x531e, 0x52f6, 0x52cd, 0x52a4, 0x527c, 0x5253, 0x522b, 0x5203,
0x51da, 0x51b2, 0x518a, 0x5162, 0x513a, 0x5112, 0x50ea, 0x50c3,
// attack env 7, -2.800000dB to -4.000000dB, delta -0.012500dB/sample
0x5c98, 0x5c76, 0x5c54, 0x5c32, 0x5c10, 0x5bee, 0x5bcc, 0x5baa,
0x5b88, 0x5b67, 0x5b45, 0x5b23, 0x5b02, 0x5ae0, 0x5abf, 0x5a9d,
0x5a7c, 0x5a5b, 0x5a3a, 0x5a18, 0x59f7, 0x59d6, 0x59b5, 0x5994,
0x5973, 0x5952, 0x5931, 0x5910, 0x58f0, 0x58cf, 0x58ae, 0x588d,
0x586d, 0x584c, 0x582c, 0x580b, 0x57eb, 0x57cb, 0x57aa, 0x578a,
0x576a, 0x574a, 0x5729, 0x5709, 0x56e9, 0x56c9, 0x56a9, 0x5689,
0x566a, 0x564a, 0x562a, 0x560a, 0x55eb, 0x55cb, 0x55ab, 0x558c,
0x556c, 0x554d, 0x552d, 0x550e, 0x54ef, 0x54d0, 0x54b0, 0x5491,
0x5472, 0x5453, 0x5434, 0x5415, 0x53f6, 0x53d7, 0x53b8, 0x5399,
0x537b, 0x535c, 0x533d, 0x531e, 0x5300, 0x52e1, 0x52c3, 0x52a4,
0x5286, 0x5267, 0x5249, 0x522b, 0x520d, 0x51ee, 0x51d0, 0x51b2,
0x5194, 0x5176, 0x5158, 0x513a, 0x511c, 0x50fe, 0x50e0, 0x50c3,
// attack env 8, -3.200000dB to -4.000000dB, delta -0.008333dB/sample
0x5878, 0x5862, 0x584c, 0x5837, 0x5821, 0x580b, 0x57f6, 0x57e0,
0x57cb, 0x57b5, 0x579f, 0x578a, 0x5774, 0x575f, 0x574a, 0x5734,
0x571f, 0x5709, 0x56f4, 0x56df, 0x56c9, 0x56b4, 0x569f, 0x5689,
0x5674, 0x565f, 0x564a, 0x5635, 0x561f, 0x560a, 0x55f5, 0x55e0,
0x55cb, 0x55b6, 0x55a1, 0x558c, 0x5577, 0x5562, 0x554d, 0x5538,
0x5523, 0x550e, 0x54f9, 0x54e4, 0x54d0, 0x54bb, 0x54a6, 0x5491,
0x547c, 0x5468, 0x5453, 0x543e, 0x5429, 0x5415, 0x5400, 0x53ec,
0x53d7, 0x53c2, 0x53ae, 0x5399, 0x5385, 0x5370, 0x535c, 0x5347,
0x5333, 0x531e, 0x530a, 0x52f6, 0x52e1, 0x52cd, 0x52b9, 0x52a4,
0x5290, 0x527c, 0x5267, 0x5253, 0x523f, 0x522b, 0x5217, 0x5203,
0x51ee, 0x51da, 0x51c6, 0x51b2, 0x519e, 0x518a, 0x5176, 0x5162,
0x514e, 0x513a, 0x5126, 0x5112, 0x50fe, 0x50ea, 0x50d7, 0x50c3,
// attack env 9, -3.600000dB to -4.000000dB, delta -0.004167dB/sample
0x5487, 0x547c, 0x5472, 0x5468, 0x545d, 0x5453, 0x5449, 0x543e,
0x5434, 0x5429, 0x541f, 0x5415, 0x540b, 0x5400, 0x53f6, 0x53ec,
0x53e1, 0x53d7, 0x53cd, 0x53c2, 0x53b8, 0x53ae, 0x53a4, 0x5399,
0x538f, 0x5385, 0x537b, 0x5370, 0x5366, 0x535c, 0x5352, 0x5347,
0x533d, 0x5333, 0x5329, 0x531e, 0x5314, 0x530a, 0x5300, 0x52f6,
0x52eb, 0x52e1, 0x52d7, 0x52cd, 0x52c3, 0x52b9, 0x52ae, 0x52a4,
0x529a, 0x5290, 0x5286, 0x527c, 0x5272, 0x5267, 0x525d, 0x5253,
0x5249, 0x523f, 0x5235, 0x522b, 0x5221, 0x5217, 0x520d, 0x5203,
0x51f8, 0x51ee, 0x51e4, 0x51da, 0x51d0, 0x51c6, 0x51bc, 0x51b2,
0x51a8, 0x519e, 0x5194, 0x518a, 0x5180, 0x5176, 0x516c, 0x5162,
0x5158, 0x514e, 0x5144, 0x513a, 0x5130, 0x5126, 0x511c, 0x5112,
0x5108, 0x50fe, 0x50f4, 0x50ea, 0x50e0, 0x50d7, 0x50cd, 0x50c3,
// sustain -4.000000dB
0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3,
0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3,
0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3,
0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3,
0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3,
0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3,
0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3,
0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3,
0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3,
0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3,
0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3,
0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3, 0x50c3,
// release env segment 0, starting at -0.400000dB, delta  0.004167dB/sample
0x7a4c, 0x7a5b, 0x7a6a, 0x7a79, 0x7a88, 0x7a97, 0x7aa6, 0x7ab5,
0x7ac4, 0x7ad3, 0x7ae2, 0x7af1, 0x7b00, 0x7b10, 0x7b1f, 0x7b2e,
0x7b3d, 0x7b4c, 0x7b5b, 0x7b6a, 0x7b79, 0x7b89, 0x7b98, 0x7ba7,
0x7bb6, 0x7bc5, 0x7bd5, 0x7be4, 0x7bf3, 0x7c02, 0x7c11, 0x7c21,
0x7c30, 0x7c3f, 0x7c4e, 0x7c5e, 0x7c6d, 0x7c7c, 0x7c8c, 0x7c9b,
0x7caa, 0x7cba, 0x7cc9, 0x7cd8, 0x7ce7, 0x7cf7, 0x7d06, 0x7d16,
0x7d25, 0x7d34, 0x7d44, 0x7d53, 0x7d62, 0x7d72, 0x7d81, 0x7d91,
0x7da0, 0x7db0, 0x7dbf, 0x7dce, 0x7dde, 0x7ded, 0x7dfd, 0x7e0c,
0x7e1c, 0x7e2b, 0x7e3b, 0x7e4a, 0x7e5a, 0x7e69, 0x7e79, 0x7e88,
0x7e98, 0x7ea7, 0x7eb7, 0x7ec7, 0x7ed6, 0x7ee6, 0x7ef5, 0x7f05,
0x7f14, 0x7f24, 0x7f34, 0x7f43, 0x7f53, 0x7f63, 0x7f72, 0x7f82,
0x7f92, 0x7fa1, 0x7fb1, 0x7fc1, 0x7fd0, 0x7fe0, 0x7ff0, 0x8000,
// release env segment 1, starting at -0.800000dB, delta  0.004167dB/sample
0x74cb, 0x74d9, 0x74e7, 0x74f6, 0x7504, 0x7512, 0x7521, 0x752f,
0x753e, 0x754c, 0x755a, 0x7569, 0x7577, 0x7586, 0x7594, 0x75a2,
0x75b1, 0x75bf, 0x75ce, 0x75dc, 0x75eb, 0x75f9, 0x7608, 0x7616,
0x7625, 0x7633, 0x7642, 0x7650, 0x765f, 0x766d, 0x767c, 0x768a,
0x7699, 0x76a8, 0x76b6, 0x76c5, 0x76d3, 0x76e2, 0x76f1, 0x76ff,
0x770e, 0x771c, 0x772b, 0x773a, 0x7748, 0x7757, 0x7766, 0x7774,
0x7783, 0x7792, 0x77a0, 0x77af, 0x77be, 0x77cc, 0x77db, 0x77ea,
0x77f9, 0x7807, 0x7816, 0x7825, 0x7834, 0x7842, 0x7851, 0x7860,
0x786f, 0x787e, 0x788c, 0x789b, 0x78aa, 0x78b9, 0x78c8, 0x78d6,
0x78e5, 0x78f4, 0x7903, 0x7912, 0x7921, 0x7930, 0x793e, 0x794d,
0x795c, 0x796b, 0x797a, 0x7989, 0x7998, 0x79a7, 0x79b6, 0x79c5,
0x79d4, 0x79e3, 0x79f2, 0x7a01, 0x7a10, 0x7a1f, 0x7a2e, 0x7a3d,
// release env segment 2, starting at -1.200000dB, delta  0.004167dB/sample
0x6f89, 0x6f97, 0x6fa4, 0x6fb2, 0x6fc0, 0x6fcd, 0x6fdb, 0x6fe9,
0x6ff7, 0x7004, 0x7012, 0x7020, 0x702e, 0x703b, 0x7049, 0x7057,
0x7065, 0x7073, 0x7080, 0x708e, 0x709c, 0x70aa, 0x70b8, 0x70c6,
0x70d4, 0x70e1, 0x70ef, 0x70fd, 0x710b, 0x7119, 0x7127, 0x7135,
0x7143, 0x7150, 0x715e, 0x716c, 0x717a, 0x7188, 0x7196, 0x71a4,
0x71b2, 0x71c0, 0x71ce, 0x71dc, 0x71ea, 0x71f8, 0x7206, 0x7214,
0x7222, 0x7230, 0x723e, 0x724c, 0x725a, 0x7268, 0x7276, 0x7284,
0x7292, 0x72a0, 0x72ae, 0x72bd, 0x72cb, 0x72d9, 0x72e7, 0x72f5,
0x7303, 0x7311, 0x731f, 0x732d, 0x733c, 0x734a, 0x7358, 0x7366,
0x7374, 0x7382, 0x7391, 0x739f, 0x73ad, 0x73bb, 0x73c9, 0x73d8,
0x73e6, 0x73f4, 0x7402, 0x7411, 0x741f, 0x742d, 0x743b, 0x744a,
0x7458, 0x7466, 0x7475, 0x7483, 0x7491, 0x74a0, 0x74ae, 0x74bc,
// release env segment 3, starting at -1.600000dB, delta  0.004167dB/sample
0x6a84, 0x6a91, 0x6a9e, 0x6aab, 0x6ab8, 0x6ac5, 0x6ad2, 0x6adf,
0x6aed, 0x6afa, 0x6b07, 0x6b14, 0x6b21, 0x6b2e, 0x6b3b, 0x6b49,
0x6b56, 0x6b63, 0x6b70, 0x6b7d, 0x6b8b, 0x6b98, 0x6ba5, 0x6bb2,
0x6bbf, 0x6bcd, 0x6bda, 0x6be7, 0x6bf4, 0x6c02, 0x6c0f, 0x6c1c,
0x6c2a, 0x6c37, 0x6c44, 0x6c51, 0x6c5f, 0x6c6c, 0x6c79, 0x6c87,
0x6c94, 0x6ca1, 0x6caf, 0x6cbc, 0x6cc9, 0x6cd7, 0x6ce4, 0x6cf2,
0x6cff, 0x6d0c, 0x6d1a, 0x6d27, 0x6d34, 0x6d42, 0x6d4f, 0x6d5d,
0x6d6a, 0x6d78, 0x6d85, 0x6d93, 0x6da0, 0x6dad, 0x6dbb, 0x6dc8,
0x6dd6, 0x6de3, 0x6df1, 0x6dfe, 0x6e0c, 0x6e19, 0x6e27, 0x6e34,
0x6e42, 0x6e50, 0x6e5d, 0x6e6b, 0x6e78, 0x6e86, 0x6e93, 0x6ea1,
0x6eaf, 0x6ebc, 0x6eca, 0x6ed7, 0x6ee5, 0x6ef3, 0x6f00, 0x6f0e,
0x6f1b, 0x6f29, 0x6f37, 0x6f44, 0x6f52, 0x6f60, 0x6f6d, 0x6f7b,
// release env segment 4, starting at -2.000000dB, delta  0.004167dB/sample
0x65b8, 0x65c5, 0x65d1, 0x65de, 0x65ea, 0x65f7, 0x6604, 0x6610,
0x661d, 0x6629, 0x6636, 0x6642, 0x664f, 0x665b, 0x6668, 0x6675,
0x6681, 0x668e, 0x669a, 0x66a7, 0x66b3, 0x66c0, 0x66cd, 0x66d9,
0x66e6, 0x66f3, 0x66ff, 0x670c, 0x6719, 0x6725, 0x6732, 0x673f,
0x674b, 0x6758, 0x6765, 0x6771, 0x677e, 0x678b, 0x6798, 0x67a4,
0x67b1, 0x67be, 0x67ca, 0x67d7, 0x67e4, 0x67f1, 0x67fd, 0x680a,
0x6817, 0x6824, 0x6831, 0x683d, 0x684a, 0x6857, 0x6864, 0x6871,
0x687d, 0x688a, 0x6897, 0x68a4, 0x68b1, 0x68be, 0x68cb, 0x68d7,
0x68e4, 0x68f1, 0x68fe, 0x690b, 0x6918, 0x6925, 0x6932, 0x693f,
0x694c, 0x6959, 0x6965, 0x6972, 0x697f, 0x698c, 0x6999, 0x69a6,
0x69b3, 0x69c0, 0x69cd, 0x69da, 0x69e7, 0x69f4, 0x6a01, 0x6a0e,
0x6a1b, 0x6a28, 0x6a35, 0x6a42, 0x6a4f, 0x6a5d, 0x6a6a, 0x6a77,
// release env segment 5, starting at -2.400000dB, delta  0.004167dB/sample
0x6124, 0x6130, 0x613c, 0x6148, 0x6154, 0x6160, 0x616c, 0x6178,
0x6184, 0x6190, 0x619c, 0x61a8, 0x61b4, 0x61c0, 0x61cc, 0x61d8,
0x61e4, 0x61f0, 0x61fc, 0x6208, 0x6214, 0x6220, 0x622c, 0x6238,
0x6244, 0x6250, 0x625d, 0x6269, 0x6275, 0x6281, 0x628d, 0x6299,
0x62a5, 0x62b1, 0x62bd, 0x62c9, 0x62d6, 0x62e2, 0x62ee, 0x62fa,
0x6306, 0x6312, 0x631f, 0x632b, 0x6337, 0x6343, 0x634f, 0x635b,
0x6368, 0x6374, 0x6380, 0x638c, 0x6399, 0x63a5, 0x63b1, 0x63bd,
0x63ca, 0x63d6, 0x63e2, 0x63ee, 0x63fb, 0x6407, 0x6413, 0x641f,
0x642c, 0x6438, 0x6444, 0x6451, 0x645d, 0x6469, 0x6476, 0x6482,
0x648e, 0x649b, 0x64a7, 0x64b3, 0x64c0, 0x64cc, 0x64d9, 0x64e5,
0x64f1, 0x64fe, 0x650a, 0x6517, 0x6523, 0x652f, 0x653c, 0x6548,
0x6555, 0x6561, 0x656e, 0x657a, 0x6587, 0x6593, 0x659f, 0x65ac,
// release env segment 6, starting at -2.800000dB, delta  0.004167dB/sample
0x5cc5, 0x5cd1, 0x5cdc, 0x5ce7, 0x5cf3, 0x5cfe, 0x5d0a, 0x5d15,
0x5d20, 0x5d2c, 0x5d37, 0x5d43, 0x5d4e, 0x5d5a, 0x5d65, 0x5d71,
0x5d7c, 0x5d88, 0x5d93, 0x5d9f, 0x5daa, 0x5db6, 0x5dc1, 0x5dcd,
0x5dd8, 0x5de4, 0x5def, 0x5dfb, 0x5e06, 0x5e12, 0x5e1d, 0x5e29,
0x5e35, 0x5e40, 0x5e4c, 0x5e57, 0x5e63, 0x5e6e, 0x5e7a, 0x5e86,
0x5e91, 0x5e9d, 0x5ea9, 0x5eb4, 0x5ec0, 0x5ecb, 0x5ed7, 0x5ee3,
0x5eee, 0x5efa, 0x5f06, 0x5f11, 0x5f1d, 0x5f29, 0x5f34, 0x5f40,
0x5f4c, 0x5f57, 0x5f63, 0x5f6f, 0x5f7b, 0x5f86, 0x5f92, 0x5f9e,
0x5faa, 0x5fb5, 0x5fc1, 0x5fcd, 0x5fd9, 0x5fe4, 0x5ff0, 0x5ffc,
0x6008, 0x6014, 0x601f, 0x602b, 0x6037, 0x6043, 0x604f, 0x605a,
0x6066, 0x6072, 0x607e, 0x608a, 0x6096, 0x60a2, 0x60ad, 0x60b9,
0x60c5, 0x60d1, 0x60dd, 0x60e9, 0x60f5, 0x6101, 0x610d, 0x6119,
// release env segment 7, starting at -3.200000dB, delta  0.004167dB/sample
0x5898, 0x58a3, 0x58ae, 0x58b9, 0x58c4, 0x58cf, 0x58da, 0x58e5,
0x58ef, 0x58fa, 0x5905, 0x5910, 0x591b, 0x5926, 0x5931, 0x593c,
0x5947, 0x5952, 0x595d, 0x5968, 0x5973, 0x597e, 0x5989, 0x5994,
0x599f, 0x59aa, 0x59b5, 0x59c0, 0x59cb, 0x59d6, 0x59e1, 0x59ec,
0x59f7, 0x5a02, 0x5a0d, 0x5a18, 0x5a23, 0x5a2e, 0x5a39, 0x5a45,
0x5a50, 0x5a5b, 0x5a66, 0x5a71, 0x5a7c, 0x5a87, 0x5a92, 0x5a9d,
0x5aa9, 0x5ab4, 0x5abf, 0x5aca, 0x5ad5, 0x5ae0, 0x5aeb, 0x5af7,
0x5b02, 0x5b0d, 0x5b18, 0x5b23, 0x5b2f, 0x5b3a, 0x5b45, 0x5b50,
0x5b5b, 0x5b67, 0x5b72, 0x5b7d, 0x5b88, 0x5b94, 0x5b9f, 0x5baa,
0x5bb5, 0x5bc1, 0x5bcc, 0x5bd7, 0x5be2, 0x5bee, 0x5bf9, 0x5c04,
0x5c10, 0x5c1b, 0x5c26, 0x5c32, 0x5c3d, 0x5c48, 0x5c54, 0x5c5f,
0x5c6a, 0x5c76, 0x5c81, 0x5c8c, 0x5c98, 0x5ca3, 0x5cae, 0x5cba,
// release env segment 8, starting at -3.600000dB, delta  0.004167dB/sample
0x549b, 0x54a6, 0x54b0, 0x54bb, 0x54c5, 0x54cf, 0x54da, 0x54e4,
0x54ef, 0x54f9, 0x5504, 0x550e, 0x5519, 0x5523, 0x552d, 0x5538,
0x5542, 0x554d, 0x5557, 0x5562, 0x556c, 0x5577, 0x5581, 0x558c,
0x5596, 0x55a1, 0x55ab, 0x55b6, 0x55c0, 0x55cb, 0x55d5, 0x55e0,
0x55eb, 0x55f5, 0x5600, 0x560a, 0x5615, 0x561f, 0x562a, 0x5635,
0x563f, 0x564a, 0x5654, 0x565f, 0x566a, 0x5674, 0x567f, 0x5689,
0x5694, 0x569f, 0x56a9, 0x56b4, 0x56bf, 0x56c9, 0x56d4, 0x56df,
0x56e9, 0x56f4, 0x56ff, 0x5709, 0x5714, 0x571f, 0x5729, 0x5734,
0x573f, 0x5749, 0x5754, 0x575f, 0x576a, 0x5774, 0x577f, 0x578a,
0x5795, 0x579f, 0x57aa, 0x57b5, 0x57c0, 0x57ca, 0x57d5, 0x57e0,
0x57eb, 0x57f6, 0x5800, 0x580b, 0x5816, 0x5821, 0x582c, 0x5837,
0x5841, 0x584c, 0x5857, 0x5862, 0x586d, 0x5878, 0x5883, 0x588d,
// release env segment 9, starting at -4.000000dB, delta  0.004167dB/sample
0x50cd, 0x50d7, 0x50e0, 0x50ea, 0x50f4, 0x50fe, 0x5108, 0x5112,
0x511c, 0x5126, 0x5130, 0x513a, 0x5144, 0x514e, 0x5158, 0x5162,
0x516c, 0x5176, 0x5180, 0x518a, 0x5194, 0x519e, 0x51a8, 0x51b2,
0x51bc, 0x51c6, 0x51d0, 0x51da, 0x51e4, 0x51ee, 0x51f8, 0x5203,
0x520d, 0x5217, 0x5221, 0x522b, 0x5235, 0x523f, 0x5249, 0x5253,
0x525d, 0x5267, 0x5272, 0x527c, 0x5286, 0x5290, 0x529a, 0x52a4,
0x52ae, 0x52b9, 0x52c3, 0x52cd, 0x52d7, 0x52e1, 0x52eb, 0x52f6,
0x5300, 0x530a, 0x5314, 0x531e, 0x5329, 0x5333, 0x533d, 0x5347,
0x5352, 0x535c, 0x5366, 0x5370, 0x537a, 0x5385, 0x538f, 0x5399,
0x53a4, 0x53ae, 0x53b8, 0x53c2, 0x53cd, 0x53d7, 0x53e1, 0x53ec,
0x53f6, 0x5400, 0x540b, 0x5415, 0x541f, 0x5429, 0x5434, 0x543e,
0x5449, 0x5453, 0x545d, 0x5468, 0x5472, 0x547c, 0x5487, 0x5491,
};

#else
ALIGNED_VAR(u16, PPC_IO_BUFFER_ALIGN, __AXCompressorDefaultTable[21*48*3] = {)
 // attack env 0, 0 to -4.0dB
0x7f63,  0x7ec7,  0x7e2b,  0x7d91,  0x7cf7,  0x7c5e,  0x7bc5,  0x7b2e,
0x7a97,  0x7a01,  0x796b,  0x78d6,  0x7842,  0x77af,  0x771c,  0x768b,
0x75f9,  0x7569,  0x74d9,  0x744a,  0x73bb,  0x732e,  0x72a0,  0x7214,
0x7188,  0x70fd,  0x7073,  0x6fe9,  0x6f60,  0x6ed7,  0x6e50,  0x6dc8,
0x6d42,  0x6cbc,  0x6c37,  0x6bb2,  0x6b2e,  0x6aab,  0x6a28,  0x69a6,
0x6925,  0x68a4,  0x6824,  0x67a4,  0x6725,  0x66a7,  0x6629,  0x65ac,
0x652f,  0x64b4,  0x6438,  0x63bd,  0x6343,  0x62ca,  0x6251,  0x61d8,
0x6160,  0x60e9,  0x6072,  0x5ffc,  0x5f86,  0x5f11,  0x5e9d,  0x5e29,
0x5db6,  0x5d43,  0x5cd1,  0x5c5f,  0x5bee,  0x5b7d,  0x5b0d,  0x5a9d,
0x5a2e,  0x59c0,  0x5952,  0x58e5,  0x5878,  0x580b,  0x579f,  0x5734,
0x56c9,  0x565f,  0x55f5,  0x558c,  0x5523,  0x54bb,  0x5453,  0x53ec,
0x5385,  0x531e,  0x52b9,  0x5253,  0x51ee,  0x518a,  0x5126,  0x50c3,
 // attack env 1, -0.4 to -4.0dB
0x79b6,  0x7930,  0x78aa,  0x7825,  0x77a0,  0x771c,  0x7699,  0x7616,
0x7594,  0x7512,  0x7491,  0x7411,  0x7391,  0x7311,  0x7292,  0x7214,
0x7196,  0x7119,  0x709c,  0x7020,  0x6fa4,  0x6f29,  0x6eaf,  0x6e35,
0x6dbb,  0x6d42,  0x6cc9,  0x6c52,  0x6bda,  0x6b63,  0x6aed,  0x6a77,
0x6a01,  0x698c,  0x6918,  0x68a4,  0x6831,  0x67be,  0x674b,  0x66d9,
0x6668,  0x65f7,  0x6587,  0x6517,  0x64a7,  0x6438,  0x63ca,  0x635c,
0x62ee,  0x6281,  0x6214,  0x61a8,  0x613c,  0x60d1,  0x6066,  0x5ffc,
0x5f92,  0x5f29,  0x5ec0,  0x5e57,  0x5def,  0x5d88,  0x5d21,  0x5cba,
0x5c54,  0x5bee,  0x5b88,  0x5b23,  0x5abf,  0x5a5b,  0x59f7,  0x5994,
0x5931,  0x58cf,  0x586d,  0x580b,  0x57aa,  0x574a,  0x56e9,  0x5689,
0x562a,  0x55cb,  0x556c,  0x550e,  0x54b0,  0x5453,  0x53f6,  0x5399,
0x533d,  0x52e1,  0x5286,  0x522b,  0x51d0,  0x5176,  0x511c,  0x50c3,
 // attack env 2, -0.8 to -4.0dB
0x744a,  0x73d8,  0x7366,  0x72f5,  0x7284,  0x7214,  0x71a4,  0x7135,
0x70c6,  0x7057,  0x6fe9,  0x6f7b,  0x6f0e,  0x6ea1,  0x6e35,  0x6dc8,
0x6d5d,  0x6cf2,  0x6c87,  0x6c1c,  0x6bb2,  0x6b49,  0x6ae0,  0x6a77,
0x6a0e,  0x69a6,  0x693f,  0x68d8,  0x6871,  0x680a,  0x67a4,  0x673f,
0x66d9,  0x6675,  0x6610,  0x65ac,  0x6548,  0x64e5,  0x6482,  0x6420,
0x63bd,  0x635c,  0x62fa,  0x6299,  0x6238,  0x61d8,  0x6178,  0x6119,
0x60b9,  0x605b,  0x5ffc,  0x5f9e,  0x5f40,  0x5ee3,  0x5e86,  0x5e29,
0x5dcd,  0x5d71,  0x5d15,  0x5cba,  0x5c5f,  0x5c04,  0x5baa,  0x5b50,
0x5af7,  0x5a9d,  0x5a45,  0x59ec,  0x5994,  0x593c,  0x58e5,  0x588d,
0x5837,  0x57e0,  0x578a,  0x5734,  0x56df,  0x5689,  0x5635,  0x55e0,
0x558c,  0x5538,  0x54e4,  0x5491,  0x543e,  0x53ec,  0x5399,  0x5347,
0x52f6,  0x52a4,  0x5253,  0x5203,  0x51b2,  0x5162,  0x5112,  0x50c3,
 // attack env 3, -1.2 to -4.0dB
0x6f1c,  0x6ebc,  0x6e5d,  0x6dfe,  0x6da0,  0x6d42,  0x6ce4,  0x6c87,
0x6c2a,  0x6bcd,  0x6b70,  0x6b14,  0x6ab8,  0x6a5d,  0x6a01,  0x69a6,
0x694c,  0x68f1,  0x6897,  0x683d,  0x67e4,  0x678b,  0x6732,  0x66d9,
0x6681,  0x6629,  0x65d2,  0x657a,  0x6523,  0x64cc,  0x6476,  0x6420,
0x63ca,  0x6374,  0x631f,  0x62ca,  0x6275,  0x6220,  0x61cc,  0x6178,
0x6124,  0x60d1,  0x607e,  0x602b,  0x5fd9,  0x5f86,  0x5f34,  0x5ee3,
0x5e91,  0x5e40,  0x5def,  0x5d9f,  0x5d4e,  0x5cfe,  0x5cae,  0x5c5f,
0x5c10,  0x5bc1,  0x5b72,  0x5b23,  0x5ad5,  0x5a87,  0x5a3a,  0x59ec,
0x599f,  0x5952,  0x5905,  0x58b9,  0x586d,  0x5821,  0x57d5,  0x578a,
0x573f,  0x56f4,  0x56a9,  0x565f,  0x5615,  0x55cb,  0x5581,  0x5538,
0x54ef,  0x54a6,  0x545d,  0x5415,  0x53cd,  0x5385,  0x533d,  0x52f6,
0x52ae,  0x5267,  0x5221,  0x51da,  0x5194,  0x514e,  0x5108,  0x50c3,
 // attack env 4, -1.6 to -4.0dB
0x6a28,  0x69da,  0x698c,  0x693f,  0x68f1,  0x68a4,  0x6857,  0x680a,
0x67be,  0x6771,  0x6725,  0x66d9,  0x668e,  0x6642,  0x65f7,  0x65ac,
0x6561,  0x6517,  0x64cc,  0x6482,  0x6438,  0x63ee,  0x63a5,  0x635c,
0x6312,  0x62ca,  0x6281,  0x6238,  0x61f0,  0x61a8,  0x6160,  0x6119,
0x60d1,  0x608a,  0x6043,  0x5ffc,  0x5fb5,  0x5f6f,  0x5f29,  0x5ee3,
0x5e9d,  0x5e57,  0x5e12,  0x5dcd,  0x5d88,  0x5d43,  0x5cfe,  0x5cba,
0x5c76,  0x5c32,  0x5bee,  0x5baa,  0x5b67,  0x5b23,  0x5ae0,  0x5a9d,
0x5a5b,  0x5a18,  0x59d6,  0x5994,  0x5952,  0x5910,  0x58cf,  0x588d,
0x584c,  0x580b,  0x57cb,  0x578a,  0x574a,  0x5709,  0x56c9,  0x5689,
0x564a,  0x560a,  0x55cb,  0x558c,  0x554d,  0x550e,  0x54d0,  0x5491,
0x5453,  0x5415,  0x53d7,  0x5399,  0x535c,  0x531e,  0x52e1,  0x52a4,
0x5267,  0x522b,  0x51ee,  0x51b2,  0x5176,  0x513a,  0x50fe,  0x50c3,
 // attack env 5, -2 to -4.0dB
0x656e,  0x652f,  0x64f1,  0x64b4,  0x6476,  0x6438,  0x63fb,  0x63bd,
0x6380,  0x6343,  0x6306,  0x62ca,  0x628d,  0x6251,  0x6214,  0x61d8,
0x619c,  0x6160,  0x6124,  0x60e9,  0x60ad,  0x6072,  0x6037,  0x5ffc,
0x5fc1,  0x5f86,  0x5f4c,  0x5f11,  0x5ed7,  0x5e9d,  0x5e63,  0x5e29,
0x5def,  0x5db6,  0x5d7c,  0x5d43,  0x5d0a,  0x5cd1,  0x5c98,  0x5c5f,
0x5c26,  0x5bee,  0x5bb5,  0x5b7d,  0x5b45,  0x5b0d,  0x5ad5,  0x5a9d,
0x5a66,  0x5a2e,  0x59f7,  0x59c0,  0x5989,  0x5952,  0x591b,  0x58e5,
0x58ae,  0x5878,  0x5841,  0x580b,  0x57d5,  0x579f,  0x576a,  0x5734,
0x56ff,  0x56c9,  0x5694,  0x565f,  0x562a,  0x55f5,  0x55c0,  0x558c,
0x5557,  0x5523,  0x54ef,  0x54bb,  0x5487,  0x5453,  0x541f,  0x53ec,
0x53b8,  0x5385,  0x5352,  0x531e,  0x52eb,  0x52b9,  0x5286,  0x5253,
0x5221,  0x51ee,  0x51bc,  0x518a,  0x5158,  0x5126,  0x50f4,  0x50c3,
 // attack env 6, -2.4 to -4.0dB
0x60e9,  0x60b9,  0x608a,  0x605b,  0x602b,  0x5ffc,  0x5fcd,  0x5f9e,
0x5f6f,  0x5f40,  0x5f11,  0x5ee3,  0x5eb4,  0x5e86,  0x5e57,  0x5e29,
0x5dfb,  0x5dcd,  0x5d9f,  0x5d71,  0x5d43,  0x5d15,  0x5ce7,  0x5cba,
0x5c8c,  0x5c5f,  0x5c32,  0x5c04,  0x5bd7,  0x5baa,  0x5b7d,  0x5b50,
0x5b23,  0x5af7,  0x5aca,  0x5a9d,  0x5a71,  0x5a45,  0x5a18,  0x59ec,
0x59c0,  0x5994,  0x5968,  0x593c,  0x5910,  0x58e5,  0x58b9,  0x588d,
0x5862,  0x5837,  0x580b,  0x57e0,  0x57b5,  0x578a,  0x575f,  0x5734,
0x5709,  0x56df,  0x56b4,  0x5689,  0x565f,  0x5635,  0x560a,  0x55e0,
0x55b6,  0x558c,  0x5562,  0x5538,  0x550e,  0x54e4,  0x54bb,  0x5491,
0x5468,  0x543e,  0x5415,  0x53ec,  0x53c2,  0x5399,  0x5370,  0x5347,
0x531e,  0x52f6,  0x52cd,  0x52a4,  0x527c,  0x5253,  0x522b,  0x5203,
0x51da,  0x51b2,  0x518a,  0x5162,  0x513a,  0x5112,  0x50ea,  0x50c3,
 // attack env 7, -2.8 to -4.0dB
0x5c98,  0x5c76,  0x5c54,  0x5c32,  0x5c10,  0x5bee,  0x5bcc,  0x5baa,
0x5b88,  0x5b67,  0x5b45,  0x5b23,  0x5b02,  0x5ae0,  0x5abf,  0x5a9d,
0x5a7c,  0x5a5b,  0x5a3a,  0x5a18,  0x59f7,  0x59d6,  0x59b5,  0x5994,
0x5973,  0x5952,  0x5931,  0x5910,  0x58f0,  0x58cf,  0x58ae,  0x588d,
0x586d,  0x584c,  0x582c,  0x580b,  0x57eb,  0x57cb,  0x57aa,  0x578a,
0x576a,  0x574a,  0x5729,  0x5709,  0x56e9,  0x56c9,  0x56a9,  0x5689,
0x566a,  0x564a,  0x562a,  0x560a,  0x55eb,  0x55cb,  0x55ab,  0x558c,
0x556c,  0x554d,  0x552d,  0x550e,  0x54ef,  0x54d0,  0x54b0,  0x5491,
0x5472,  0x5453,  0x5434,  0x5415,  0x53f6,  0x53d7,  0x53b8,  0x5399,
0x537b,  0x535c,  0x533d,  0x531e,  0x5300,  0x52e1,  0x52c3,  0x52a4,
0x5286,  0x5267,  0x5249,  0x522b,  0x520d,  0x51ee,  0x51d0,  0x51b2,
0x5194,  0x5176,  0x5158,  0x513a,  0x511c,  0x50fe,  0x50e0,  0x50c3,
 // attack env 8, -3.2 to -4.0dB
0x5878,  0x5862,  0x584c,  0x5837,  0x5821,  0x580b,  0x57f6,  0x57e0,
0x57cb,  0x57b5,  0x579f,  0x578a,  0x5774,  0x575f,  0x574a,  0x5734,
0x571f,  0x5709,  0x56f4,  0x56df,  0x56c9,  0x56b4,  0x569f,  0x5689,
0x5674,  0x565f,  0x564a,  0x5635,  0x561f,  0x560a,  0x55f5,  0x55e0,
0x55cb,  0x55b6,  0x55a1,  0x558c,  0x5577,  0x5562,  0x554d,  0x5538,
0x5523,  0x550e,  0x54f9,  0x54e4,  0x54d0,  0x54bb,  0x54a6,  0x5491,
0x547c,  0x5468,  0x5453,  0x543e,  0x5429,  0x5415,  0x5400,  0x53ec,
0x53d7,  0x53c2,  0x53ae,  0x5399,  0x5385,  0x5370,  0x535c,  0x5347,
0x5333,  0x531e,  0x530a,  0x52f6,  0x52e1,  0x52cd,  0x52b9,  0x52a4,
0x5290,  0x527c,  0x5267,  0x5253,  0x523f,  0x522b,  0x5217,  0x5203,
0x51ee,  0x51da,  0x51c6,  0x51b2,  0x519e,  0x518a,  0x5176,  0x5162,
0x514e,  0x513a,  0x5126,  0x5112,  0x50fe,  0x50ea,  0x50d7,  0x50c3,
 // attack env 9, -3.6 to -4.0dB
0x5487,  0x547c,  0x5472,  0x5468,  0x545d,  0x5453,  0x5449,  0x543e,
0x5434,  0x5429,  0x541f,  0x5415,  0x540b,  0x5400,  0x53f6,  0x53ec,
0x53e1,  0x53d7,  0x53cd,  0x53c2,  0x53b8,  0x53ae,  0x53a4,  0x5399,
0x538f,  0x5385,  0x537b,  0x5370,  0x5366,  0x535c,  0x5352,  0x5347,
0x533d,  0x5333,  0x5329,  0x531e,  0x5314,  0x530a,  0x5300,  0x52f6,
0x52eb,  0x52e1,  0x52d7,  0x52cd,  0x52c3,  0x52b9,  0x52ae,  0x52a4,
0x529a,  0x5290,  0x5286,  0x527c,  0x5272,  0x5267,  0x525d,  0x5253,
0x5249,  0x523f,  0x5235,  0x522b,  0x5221,  0x5217,  0x520d,  0x5203,
0x51f8,  0x51ee,  0x51e4,  0x51da,  0x51d0,  0x51c6,  0x51bc,  0x51b2,
0x51a8,  0x519e,  0x5194,  0x518a,  0x5180,  0x5176,  0x516c,  0x5162,
0x5158,  0x514e,  0x5144,  0x513a,  0x5130,  0x5126,  0x511c,  0x5112,
0x5108,  0x50fe,  0x50f4,  0x50ea,  0x50e0,  0x50d7,  0x50cd,  0x50c3,
 // attack env 10, -4 to -4.0dB
0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,
0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,
0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,
0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,
0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,
0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,
0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,
0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,
0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,
0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,
0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,
0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,  0x50c3,
 // release env 0, -0.4 to -4.0dB
0x7a4c,  0x7a5b,  0x7a6a,  0x7a79,  0x7a88,  0x7a97,  0x7aa6,  0x7ab5,
0x7ac4,  0x7ad3,  0x7ae2,  0x7af1,  0x7b00,  0x7b10,  0x7b1f,  0x7b2e,
0x7b3d,  0x7b4c,  0x7b5b,  0x7b6a,  0x7b7a,  0x7b89,  0x7b98,  0x7ba7,
0x7bb6,  0x7bc5,  0x7bd5,  0x7be4,  0x7bf3,  0x7c02,  0x7c12,  0x7c21,
0x7c30,  0x7c3f,  0x7c4f,  0x7c5e,  0x7c6d,  0x7c7c,  0x7c8c,  0x7c9b,
0x7caa,  0x7cba,  0x7cc9,  0x7cd8,  0x7ce8,  0x7cf7,  0x7d06,  0x7d16,
0x7d25,  0x7d34,  0x7d44,  0x7d53,  0x7d63,  0x7d72,  0x7d81,  0x7d91,
0x7da0,  0x7db0,  0x7dbf,  0x7dce,  0x7dde,  0x7ded,  0x7dfd,  0x7e0c,
0x7e1c,  0x7e2b,  0x7e3b,  0x7e4a,  0x7e5a,  0x7e69,  0x7e79,  0x7e88,
0x7e98,  0x7ea8,  0x7eb7,  0x7ec7,  0x7ed6,  0x7ee6,  0x7ef5,  0x7f05,
0x7f15,  0x7f24,  0x7f34,  0x7f43,  0x7f53,  0x7f63,  0x7f72,  0x7f82,
0x7f92,  0x7fa1,  0x7fb1,  0x7fc1,  0x7fd0,  0x7fe0,  0x7ff0,  0x8000,
 // release env 1, -0.8 to -4.0dB
0x74cb,  0x74d9,  0x74e7,  0x74f6,  0x7504,  0x7512,  0x7521,  0x752f,
0x753e,  0x754c,  0x755a,  0x7569,  0x7577,  0x7586,  0x7594,  0x75a3,
0x75b1,  0x75bf,  0x75ce,  0x75dc,  0x75eb,  0x75f9,  0x7608,  0x7616,
0x7625,  0x7633,  0x7642,  0x7650,  0x765f,  0x766d,  0x767c,  0x768b,
0x7699,  0x76a8,  0x76b6,  0x76c5,  0x76d3,  0x76e2,  0x76f1,  0x76ff,
0x770e,  0x771c,  0x772b,  0x773a,  0x7748,  0x7757,  0x7766,  0x7774,
0x7783,  0x7792,  0x77a0,  0x77af,  0x77be,  0x77cd,  0x77db,  0x77ea,
0x77f9,  0x7807,  0x7816,  0x7825,  0x7834,  0x7842,  0x7851,  0x7860,
0x786f,  0x787e,  0x788c,  0x789b,  0x78aa,  0x78b9,  0x78c8,  0x78d6,
0x78e5,  0x78f4,  0x7903,  0x7912,  0x7921,  0x7930,  0x793f,  0x794d,
0x795c,  0x796b,  0x797a,  0x7989,  0x7998,  0x79a7,  0x79b6,  0x79c5,
0x79d4,  0x79e3,  0x79f2,  0x7a01,  0x7a10,  0x7a1f,  0x7a2e,  0x7a3d,
 // release env 2, -1.2 to -4.0dB
0x6f89,  0x6f97,  0x6fa4,  0x6fb2,  0x6fc0,  0x6fcd,  0x6fdb,  0x6fe9,
0x6ff7,  0x7004,  0x7012,  0x7020,  0x702e,  0x703c,  0x7049,  0x7057,
0x7065,  0x7073,  0x7081,  0x708e,  0x709c,  0x70aa,  0x70b8,  0x70c6,
0x70d4,  0x70e1,  0x70ef,  0x70fd,  0x710b,  0x7119,  0x7127,  0x7135,
0x7143,  0x7151,  0x715e,  0x716c,  0x717a,  0x7188,  0x7196,  0x71a4,
0x71b2,  0x71c0,  0x71ce,  0x71dc,  0x71ea,  0x71f8,  0x7206,  0x7214,
0x7222,  0x7230,  0x723e,  0x724c,  0x725a,  0x7268,  0x7276,  0x7284,
0x7292,  0x72a0,  0x72af,  0x72bd,  0x72cb,  0x72d9,  0x72e7,  0x72f5,
0x7303,  0x7311,  0x731f,  0x732e,  0x733c,  0x734a,  0x7358,  0x7366,
0x7374,  0x7383,  0x7391,  0x739f,  0x73ad,  0x73bb,  0x73ca,  0x73d8,
0x73e6,  0x73f4,  0x7402,  0x7411,  0x741f,  0x742d,  0x743c,  0x744a,
0x7458,  0x7466,  0x7475,  0x7483,  0x7491,  0x74a0,  0x74ae,  0x74bc,
 // release env 3, -1.6 to -4.0dB
0x6a84,  0x6a91,  0x6a9e,  0x6aab,  0x6ab8,  0x6ac5,  0x6ad2,  0x6ae0,
0x6aed,  0x6afa,  0x6b07,  0x6b14,  0x6b21,  0x6b2e,  0x6b3c,  0x6b49,
0x6b56,  0x6b63,  0x6b70,  0x6b7d,  0x6b8b,  0x6b98,  0x6ba5,  0x6bb2,
0x6bc0,  0x6bcd,  0x6bda,  0x6be7,  0x6bf5,  0x6c02,  0x6c0f,  0x6c1c,
0x6c2a,  0x6c37,  0x6c44,  0x6c52,  0x6c5f,  0x6c6c,  0x6c79,  0x6c87,
0x6c94,  0x6ca1,  0x6caf,  0x6cbc,  0x6cc9,  0x6cd7,  0x6ce4,  0x6cf2,
0x6cff,  0x6d0c,  0x6d1a,  0x6d27,  0x6d35,  0x6d42,  0x6d4f,  0x6d5d,
0x6d6a,  0x6d78,  0x6d85,  0x6d93,  0x6da0,  0x6dae,  0x6dbb,  0x6dc8,
0x6dd6,  0x6de3,  0x6df1,  0x6dfe,  0x6e0c,  0x6e19,  0x6e27,  0x6e35,
0x6e42,  0x6e50,  0x6e5d,  0x6e6b,  0x6e78,  0x6e86,  0x6e93,  0x6ea1,
0x6eaf,  0x6ebc,  0x6eca,  0x6ed7,  0x6ee5,  0x6ef3,  0x6f00,  0x6f0e,
0x6f1c,  0x6f29,  0x6f37,  0x6f45,  0x6f52,  0x6f60,  0x6f6e,  0x6f7b,
 // release env 4, -2 to -4.0dB
0x65b9,  0x65c5,  0x65d2,  0x65de,  0x65eb,  0x65f7,  0x6604,  0x6610,
0x661d,  0x6629,  0x6636,  0x6642,  0x664f,  0x665b,  0x6668,  0x6675,
0x6681,  0x668e,  0x669a,  0x66a7,  0x66b4,  0x66c0,  0x66cd,  0x66d9,
0x66e6,  0x66f3,  0x66ff,  0x670c,  0x6719,  0x6725,  0x6732,  0x673f,
0x674b,  0x6758,  0x6765,  0x6771,  0x677e,  0x678b,  0x6798,  0x67a4,
0x67b1,  0x67be,  0x67cb,  0x67d7,  0x67e4,  0x67f1,  0x67fe,  0x680a,
0x6817,  0x6824,  0x6831,  0x683d,  0x684a,  0x6857,  0x6864,  0x6871,
0x687e,  0x688a,  0x6897,  0x68a4,  0x68b1,  0x68be,  0x68cb,  0x68d8,
0x68e4,  0x68f1,  0x68fe,  0x690b,  0x6918,  0x6925,  0x6932,  0x693f,
0x694c,  0x6959,  0x6966,  0x6972,  0x697f,  0x698c,  0x6999,  0x69a6,
0x69b3,  0x69c0,  0x69cd,  0x69da,  0x69e7,  0x69f4,  0x6a01,  0x6a0e,
0x6a1b,  0x6a28,  0x6a35,  0x6a42,  0x6a50,  0x6a5d,  0x6a6a,  0x6a77,
 // release env 5, -2.4 to -4.0dB
0x6124,  0x6130,  0x613c,  0x6148,  0x6154,  0x6160,  0x616c,  0x6178,
0x6184,  0x6190,  0x619c,  0x61a8,  0x61b4,  0x61c0,  0x61cc,  0x61d8,
0x61e4,  0x61f0,  0x61fc,  0x6208,  0x6214,  0x6220,  0x622c,  0x6238,
0x6244,  0x6251,  0x625d,  0x6269,  0x6275,  0x6281,  0x628d,  0x6299,
0x62a5,  0x62b1,  0x62bd,  0x62ca,  0x62d6,  0x62e2,  0x62ee,  0x62fa,
0x6306,  0x6312,  0x631f,  0x632b,  0x6337,  0x6343,  0x634f,  0x635c,
0x6368,  0x6374,  0x6380,  0x638c,  0x6399,  0x63a5,  0x63b1,  0x63bd,
0x63ca,  0x63d6,  0x63e2,  0x63ee,  0x63fb,  0x6407,  0x6413,  0x6420,
0x642c,  0x6438,  0x6444,  0x6451,  0x645d,  0x6469,  0x6476,  0x6482,
0x648e,  0x649b,  0x64a7,  0x64b4,  0x64c0,  0x64cc,  0x64d9,  0x64e5,
0x64f1,  0x64fe,  0x650a,  0x6517,  0x6523,  0x652f,  0x653c,  0x6548,
0x6555,  0x6561,  0x656e,  0x657a,  0x6587,  0x6593,  0x65a0,  0x65ac,
 // release env 6, -2.8 to -4.0dB
0x5cc5,  0x5cd1,  0x5cdc,  0x5ce7,  0x5cf3,  0x5cfe,  0x5d0a,  0x5d15,
0x5d21,  0x5d2c,  0x5d37,  0x5d43,  0x5d4e,  0x5d5a,  0x5d65,  0x5d71,
0x5d7c,  0x5d88,  0x5d93,  0x5d9f,  0x5daa,  0x5db6,  0x5dc1,  0x5dcd,
0x5dd8,  0x5de4,  0x5def,  0x5dfb,  0x5e06,  0x5e12,  0x5e1d,  0x5e29,
0x5e35,  0x5e40,  0x5e4c,  0x5e57,  0x5e63,  0x5e6f,  0x5e7a,  0x5e86,
0x5e91,  0x5e9d,  0x5ea9,  0x5eb4,  0x5ec0,  0x5ecb,  0x5ed7,  0x5ee3,
0x5eee,  0x5efa,  0x5f06,  0x5f11,  0x5f1d,  0x5f29,  0x5f34,  0x5f40,
0x5f4c,  0x5f58,  0x5f63,  0x5f6f,  0x5f7b,  0x5f86,  0x5f92,  0x5f9e,
0x5faa,  0x5fb5,  0x5fc1,  0x5fcd,  0x5fd9,  0x5fe4,  0x5ff0,  0x5ffc,
0x6008,  0x6014,  0x601f,  0x602b,  0x6037,  0x6043,  0x604f,  0x605b,
0x6066,  0x6072,  0x607e,  0x608a,  0x6096,  0x60a2,  0x60ad,  0x60b9,
0x60c5,  0x60d1,  0x60dd,  0x60e9,  0x60f5,  0x6101,  0x610d,  0x6119,
 // release env 7, -3.2 to -4.0dB
0x5898,  0x58a3,  0x58ae,  0x58b9,  0x58c4,  0x58cf,  0x58da,  0x58e5,
0x58f0,  0x58fa,  0x5905,  0x5910,  0x591b,  0x5926,  0x5931,  0x593c,
0x5947,  0x5952,  0x595d,  0x5968,  0x5973,  0x597e,  0x5989,  0x5994,
0x599f,  0x59aa,  0x59b5,  0x59c0,  0x59cb,  0x59d6,  0x59e1,  0x59ec,
0x59f7,  0x5a02,  0x5a0d,  0x5a18,  0x5a23,  0x5a2e,  0x5a3a,  0x5a45,
0x5a50,  0x5a5b,  0x5a66,  0x5a71,  0x5a7c,  0x5a87,  0x5a92,  0x5a9d,
0x5aa9,  0x5ab4,  0x5abf,  0x5aca,  0x5ad5,  0x5ae0,  0x5aeb,  0x5af7,
0x5b02,  0x5b0d,  0x5b18,  0x5b23,  0x5b2f,  0x5b3a,  0x5b45,  0x5b50,
0x5b5b,  0x5b67,  0x5b72,  0x5b7d,  0x5b88,  0x5b94,  0x5b9f,  0x5baa,
0x5bb5,  0x5bc1,  0x5bcc,  0x5bd7,  0x5be2,  0x5bee,  0x5bf9,  0x5c04,
0x5c10,  0x5c1b,  0x5c26,  0x5c32,  0x5c3d,  0x5c48,  0x5c54,  0x5c5f,
0x5c6a,  0x5c76,  0x5c81,  0x5c8c,  0x5c98,  0x5ca3,  0x5cae,  0x5cba,
 // release env 8, -3.6 to -4.0dB
0x549b,  0x54a6,  0x54b0,  0x54bb,  0x54c5,  0x54d0,  0x54da,  0x54e4,
0x54ef,  0x54f9,  0x5504,  0x550e,  0x5519,  0x5523,  0x552d,  0x5538,
0x5542,  0x554d,  0x5557,  0x5562,  0x556c,  0x5577,  0x5581,  0x558c,
0x5596,  0x55a1,  0x55ab,  0x55b6,  0x55c0,  0x55cb,  0x55d5,  0x55e0,
0x55eb,  0x55f5,  0x5600,  0x560a,  0x5615,  0x561f,  0x562a,  0x5635,
0x563f,  0x564a,  0x5654,  0x565f,  0x566a,  0x5674,  0x567f,  0x5689,
0x5694,  0x569f,  0x56a9,  0x56b4,  0x56bf,  0x56c9,  0x56d4,  0x56df,
0x56e9,  0x56f4,  0x56ff,  0x5709,  0x5714,  0x571f,  0x5729,  0x5734,
0x573f,  0x574a,  0x5754,  0x575f,  0x576a,  0x5774,  0x577f,  0x578a,
0x5795,  0x579f,  0x57aa,  0x57b5,  0x57c0,  0x57cb,  0x57d5,  0x57e0,
0x57eb,  0x57f6,  0x5800,  0x580b,  0x5816,  0x5821,  0x582c,  0x5837,
0x5841,  0x584c,  0x5857,  0x5862,  0x586d,  0x5878,  0x5883,  0x588d,
 // release env 9, -4 to -4.0dB
0x50cd,  0x50d7,  0x50e0,  0x50ea,  0x50f4,  0x50fe,  0x5108,  0x5112,
0x511c,  0x5126,  0x5130,  0x513a,  0x5144,  0x514e,  0x5158,  0x5162,
0x516c,  0x5176,  0x5180,  0x518a,  0x5194,  0x519e,  0x51a8,  0x51b2,
0x51bc,  0x51c6,  0x51d0,  0x51da,  0x51e4,  0x51ee,  0x51f8,  0x5203,
0x520d,  0x5217,  0x5221,  0x522b,  0x5235,  0x523f,  0x5249,  0x5253,
0x525d,  0x5267,  0x5272,  0x527c,  0x5286,  0x5290,  0x529a,  0x52a4,
0x52ae,  0x52b9,  0x52c3,  0x52cd,  0x52d7,  0x52e1,  0x52eb,  0x52f6,
0x5300,  0x530a,  0x5314,  0x531e,  0x5329,  0x5333,  0x533d,  0x5347,
0x5352,  0x535c,  0x5366,  0x5370,  0x537b,  0x5385,  0x538f,  0x5399,
0x53a4,  0x53ae,  0x53b8,  0x53c2,  0x53cd,  0x53d7,  0x53e1,  0x53ec,
0x53f6,  0x5400,  0x540b,  0x5415,  0x541f,  0x5429,  0x5434,  0x543e,
0x5449,  0x5453,  0x545d,  0x5468,  0x5472,  0x547c,  0x5487,  0x5491,
}; // end of Compressor Table for 48kHz

#endif // COMPRESSOR_32KHZ

/*---------------------------------------------------------------------------*
  Name:         AXMakeCompressorTable

  Description:  make user defined compressor table.

  Arguments:    gain    target gain
                frames  release time (specified by audio frames)
                table   pointer of compressor table.

  Returns:      none.
 *---------------------------------------------------------------------------*/
#define AX_AUDIO_OUT_FRAME_SIZE (48*3)
void AXMakeCompressorTable(f32 gain, u16 frames, u16* table)
{
    u16  utmp;
    u16* ptr;
    s32  ii, jj;
    f32  step;
    f32  sdB;
    f32  edB;
    f32  ddB;
    f32  cdB;

    ASSERT(gain < 0.0f && frames > 0 && frames <= 30000 && table);

    if (gain >= 0.0f || frames == 0 || frames > 30000 || !table)
    {
        return;
    }

    ptr = table;

    // attack
    step = gain / frames;
    sdB  = 0.0;
    edB  = gain;

    for (ii = 0; ii < frames; ii++)
    {
        ddB = (edB - sdB) / AX_AUDIO_OUT_FRAME_SIZE;
        cdB = sdB;

        for (jj = 0; jj < AX_AUDIO_OUT_FRAME_SIZE; jj++)
        {
            cdB   += ddB;
            utmp   = (u16)(32768.0f * pow(10.0, cdB / 20.0) + 0.5f);
            *ptr++ = utmp;
        }

        sdB += step;
    }

    // sustain
    cdB  = gain;
    utmp = (u16)(32768.0f * pow(10.0, cdB / 20.0) + 0.5f);
    for (ii = 0; ii < AX_AUDIO_OUT_FRAME_SIZE; ii++)
    {
        *ptr++ = utmp;
    }

    // release
    step = -gain / frames;
    sdB  = -step;
    edB  = 0.0;
    ddB  = step / AX_AUDIO_OUT_FRAME_SIZE;

    for (ii = 0; ii < frames; ii++)
    {
        cdB = sdB;

        for (jj = 0; jj < AX_AUDIO_OUT_FRAME_SIZE; jj++)
        {
            cdB   += ddB;
            utmp   = (u16)(32768.0f * pow(10.0, cdB / 20.0) + 0.5f);
            *ptr++ = utmp;
        }

        edB  = sdB;
        sdB -= step;
    }

//    DCFlushRange(table, AX_AUDIO_OUT_FRAME_SIZE * (2 * frames + 1) * sizeof(u16));
}
/*---------------------------------------------------------------------------*
  Name:         AXSetDeviceCompressor

  Description:  set user defined compressor table.

Arguments:    device  type of device : TV, DRC, RMT
              Id      device #
              on_off  1->ON, 0->OFF

  Returns:    error code if any
 *---------------------------------------------------------------------------*/

AXPB_ERROR_CODE AXSetDeviceCompressor( AXPBDeviceType device, u16 on_off)
{
    AXPB_ERROR_CODE retErrCode = AXPB_ERROR_NONE;
    // Steps:
    // - Check for validity of the inputs
    // - in the switch code, set up max channels, pointers appropriately
    retErrCode = (device >= AX_MAX_NUM_DEVICES ? AXPB_ERROR_DEVICE_TYPE : AXPB_ERROR_NONE);
    if(AXPB_ERROR_NONE == retErrCode)
    {
        __AXDeviceCompressorSwitch[device] = on_off;
    } // end of error checking

    return retErrCode;
} // end of AXSetDeviceCompressorTable
/*---------------------------------------------------------------------------*
  Name:         AXSetDeviceCompressorTable

  Description:  set user defined compressor table.

Arguments:    device  type of device : TV, DRC, RMT
              Id      device #
              table   pointer of compressor table.
              frames  release time (specified by audio frames)

  Returns:    error code if any
 *---------------------------------------------------------------------------*/

AXPB_ERROR_CODE AXSetDeviceCompressorTable( AXPBDeviceType device, u16* table, u16 frames)
{
    AXPB_ERROR_CODE retErrCode = AXPB_ERROR_NONE;
    // Steps:
    // - Check for validity of the inputs
    // - in the switch code, set up max channels, pointers appropriately
    retErrCode = (device >= AX_MAX_NUM_DEVICES ? AXPB_ERROR_DEVICE_TYPE : AXPB_ERROR_NONE);
    if(AXPB_ERROR_NONE == retErrCode)
    {
        ASSERT(!((u32)table & 0x1f));
        ASSERT(!table || (table && frames > 0 && frames <= 30000));

        if ((u32)table & 0x1f || (table && (frames == 0 || frames > 30000)))
        {
            return AXPB_ERROR_ILLEGAL_COMPRESSOR_SETTINGS;
        }

        if(!table)
        {
            __AXDeviceCompressorTable[device] = __AXCompressorDefaultTable;
            __AXDeviceCompReleaseFrames[device] = COMPRESSOR_RELEASE_STAGES;
        }
        else
        {
            __AXDeviceCompressorTable[device] = table;
            __AXDeviceCompReleaseFrames[device] = frames;
            // values in table may not be in main memory, flush them
//            DCFlushRange(table, (32 * 3) * (2 * frames + 1) * sizeof(u16));
        }

    } // end of error checking

    return retErrCode;
} // end of AXSetDeviceCompressorTable

void __AXCompInit()
{
    u32 deviceCnt;
    for(deviceCnt=0; deviceCnt < AX_MAX_NUM_DEVICES ; deviceCnt++)
    {
        __AXDeviceCompressorTable[deviceCnt] = __AXCompressorDefaultTable;
        __AXDeviceCompressorSwitch[deviceCnt] = 0;
        __AXDeviceCompReleaseFrames[deviceCnt] = COMPRESSOR_RELEASE_STAGES;
    }

    // set the individual devices compstate to 0
    // tV
    for(deviceCnt=0; deviceCnt < AX_MAX_NUM_TVS; deviceCnt++)
    {
        __AXTVCompState[deviceCnt] = 0;
    }

    // drcs
    for(deviceCnt=0; deviceCnt < AX_MAX_NUM_DRCS; deviceCnt++)
    {
        __AXDRCCompState[deviceCnt] = 0;
    }

    // rmts
    for(deviceCnt=0; deviceCnt < AX_MAX_NUM_RMTS; deviceCnt++)
    {
        __AXRMTCompState[deviceCnt] = 0;
    }

}
/*==============================================================================
 * Function:  __AXApplyCompressorOneDevice
 * Arguments: input     : pointer to the input samples
 *            table     : pointer to the compressor table to be used
 *            numSamples: number of samples for which compressor need to be applied
 *            numChannels: number of channels for which compressor needs to be applied
 * Description:
 *  Applies the compressor for one channel pointed by input
 *  Basic algo as follows:
 *      - check if the input exceeds threshold for this frame.
 *          - YES: bring down volume immediately from its current level to -4dB
 *          - NO: if the previous frame didnt have a ramp, then do nothing
 *                if the previous frame had a ramp, then ramp
 *==============================================================================*/
void __AXApplyCompressorOneDevice(s32 *input, u16 const *table, u32 const numSamples,
                                    const u32 numChannels, u32 *compState, const u32 compReleaseFrames)
{
    s32 *tmpInput;
    u16 const *tmpTablePtr;
    u32 chCnt, sampCnt;
    BOOL compDetected = FALSE;
    // detect threshold
    for(chCnt = 0; chCnt < numChannels ; chCnt++)
    {
        tmpInput = input + chCnt*numSamples;
        for(sampCnt = 0 ; sampCnt < numSamples ; sampCnt++)
        {
            if(*tmpInput > COMPRESSOR_THRESHOLD )
            {
                compDetected = TRUE;
                break;
            }

            tmpInput++;

        } // for all samples

        if(compDetected)
        {
            break;
        }
    } // for all channels

    // algo: we have determined if the threshold has exceeded or not


    BOOL bApplyCompressor = FALSE;
    if(compDetected)
    {
        // current frame exceeds threshold, bring down the volume to -4dB
        // use the previous frames comp_State while doing that
        // get the pointer to the portion of the table to be used
        tmpTablePtr = table + ( (*compState) *numSamples);
        *compState = compReleaseFrames;
        bApplyCompressor = TRUE;

    }
    else
    {
        // current frame didnt exceed threshold
        // check the compState
        //   - if compState was not set earlier, do nothing
        //
        if( (*compState))
        {
            // we were ramping up in the previous frame, keep ramping up
            tmpTablePtr = table + ( (*compState + compReleaseFrames)*numSamples);
            bApplyCompressor = TRUE;

            // reduce compState by 1
            *compState--;
        }
    } // end of if(compDetected)


    // prepare the ramp based on the previous state of the compressor
    //
    //
    // Main things to remember:
    //   - the compressor applied should be same for all the channels of this device
    //   - the compressor state is per device and device type

    if(bApplyCompressor)
    {
        for(chCnt=0; chCnt < numChannels; chCnt++)
        {
            tmpInput = input + chCnt*numSamples;
            __AXApplyCompressorOneChannel(tmpInput, tmpTablePtr, numSamples);
        }
    }


} //void __AXApplyCompressorOneChannel(s32 *input, u16 *table, u32 numSamples)
/*==============================================================================
 * Function:  __AXApplyCompressorOneChannel
 * Arguments: input     : pointer to the input samples
 *            table     : pointer to the compressor table to be used
 *            numSamples: number of samples for which compressor need to be applied
 * Description:
 *  Applies the compressor for one channel pointed by input
 *==============================================================================*/
void __AXApplyCompressorOneChannel(s32 *input, u16 const *table, u32 const numSamples)
{
    u32 sCnt;
    f32 tmpInput;
    f32 fgain;
    for(sCnt=0; sCnt < numSamples ; sCnt++)
    {
        tmpInput = (f32) (*input);
        fgain  = (f32) (*table++);
        fgain = fgain / (0x8000);
        tmpInput = tmpInput* fgain;
        *input++ = (s32)(tmpInput );
    }
} //void __AXApplyCompressorOneChannel(s32 *input, u16 *table, u32 numSamples)
/*==============================================================================
 * Function:  __AXApplyDeviceCompressor
 * Arguments: input     : pointer to the input samples
 *            deviceType: device type
 * Description:
 *  Applies the compressor for one channel pointed by input
 *==============================================================================*/
void __AXApplyDeviceCompressor(s32 *input, AXPBDeviceType const deviceType, u32 const deviceId)
{
    u16 *table;
    u32 *state;
    u32 releaseFrames;
    u32 numChannels;

    // check if compressor is on for this device
    if(!__AXDeviceCompressorSwitch[deviceType])
    {
        return;
    }

    table = __AXDeviceCompressorTable[deviceType];
    releaseFrames = __AXDeviceCompReleaseFrames[deviceType];
    switch(deviceType)
    {
        case AX_DEVICE_TV:
            state = &__AXTVCompState[deviceId];
            numChannels = AX_MAX_NUM_TV_CHS;
            break;
        case AX_DEVICE_DRC:
            state = &__AXDRCCompState[deviceId];
            numChannels = AX_MAX_NUM_DRC_CHS;
            break;
        case AX_DEVICE_RMT:
            state = &__AXRMTCompState[deviceId];
            numChannels = AX_MAX_NUM_RMT_CHS;
            break;

    } // end of switch(deviceType)
    __AXApplyCompressorOneDevice(input, table, AX_AUDIO_OUT_FRAME_SIZE, numChannels , state, releaseFrames);
}// end of __AXApplyDeviceCompressor


} // namespace winext
} // namespace internal
} // namespace nw
