﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
//#include "afxwin.h"

#include <Windows.h>

namespace nw {
namespace internal {
namespace winext {

class CSoundEngine
{
public:
    typedef void (*WaveOutCallbackFunc)(
            int channels,
            signed short* buffer,
            unsigned long samples,
            int sampleRate);

    WaveOutCallbackFunc GetWaveOutCallback()
    {
        return m_WaveOutProc;
    }

    WaveOutCallbackFunc SetWaveOutCallback( WaveOutCallbackFunc func )
    {
        if(m_WaveOutProc == func)
        {
            return NULL;
        }

        WaveOutCallbackFunc oldFunc = m_WaveOutProc;
        m_WaveOutProc = func;

        return oldFunc;
    }

    virtual BOOL IsActive() const = 0;
    virtual BOOL OpenStream( UINT devideID ) = 0;
    virtual void CloseStream() = 0;

    virtual unsigned long GetBufferLength() = 0;

protected:
    static const int CHANNEL_COUNT = 2;

    CSoundEngine()
    : m_WaveOutProc( NULL )
    {}
    virtual ~CSoundEngine() {}

    void WaveOutCallback(
            int channels,
            signed short* buffer,
            unsigned long samples,
            int sampleRate )
    {
        if ( m_WaveOutProc )
        {
            m_WaveOutProc( channels, buffer, samples, sampleRate );
        }
    }

private:
    WaveOutCallbackFunc m_WaveOutProc;

};

} // namespace winext
} // namespace internal
} // namespace nw
