﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/math.h>

#include <nw/math/math_Transform.h>

namespace nw { namespace math {

/* ------------------------------------------------------------------------
        簡易レポート用関数
   ------------------------------------------------------------------------ */

/*!--------------------------------------------------------------------------*
  Name:         Transform2::Report

  @brief        Transform2 の内容をデバッグ出力に書き出します。

  @param[in]    bNewline  true なら出力の最後に改行を出力します。
  @param[in]    name    Transform2 の名前を指定します。NULL指定可能です。

  @return       なし
 *---------------------------------------------------------------------------*/
void
Transform2::Report(bool bNewline, const char* name) const
{
    if (name) { NW_MATH_REPORT("%s", name); }
    else { NW_MATH_REPORT("Transform2\n"); }

    NW_MATH_REPORT("Scale    <%f, %f>\n", scale.x, scale.y);
    NW_MATH_REPORT("Rotate   <%f, %f>\n", rotate.x, rotate.y);
    NW_MATH_REPORT("Translate<%f, %f>\n", translate.x, translate.y);

    if (bNewline) { NW_MATH_REPORT("\n"); }
}

/*!--------------------------------------------------------------------------*
  Name:         Transform3::Report

  @brief        Transform3 の内容をデバッグ出力に書き出します。

  @param[in]    bNewline  true なら出力の最後に改行を出力します。
  @param[in]    name    Transform3 の名前を指定します。NULL指定可能です。

  @return       なし
 *---------------------------------------------------------------------------*/
void
Transform3::Report(bool bNewline, const char* name) const
{
    if (name) { NW_MATH_REPORT("%s", name); }
    else { NW_MATH_REPORT("Transform3\n"); }

    NW_MATH_REPORT("Scale    <%f, %f, %f>\n", scale.x, scale.y, scale.z);
    NW_MATH_REPORT("Rotate   <%f, %f, %f>\n", rotate.x, rotate.y, rotate.z);
    NW_MATH_REPORT("Translate<%f, %f, %f>\n", translate.x, translate.y, translate.z);

    if (bNewline) { NW_MATH_REPORT("\n"); }
}


}  // namespace math
}  // namespace nw
