﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/gfnd/gl/gfnd_TextureGL.h>

namespace nw
{
namespace gfnd
{

//--------------------------------------------------------------------------
bool
TextureGL::CreateTextureImage2D(
    GLint level,
    GLint internalFormat,
    GLsizei width,
    GLsizei height,
    GLint border,
    GLint format,
    GLenum type,
    const GLvoid* pixels
)
{
    GLuint tex;
    {
        glGenTextures( 1, &tex );
        glBindTexture( GL_TEXTURE_2D, tex );
        glTexImage2D( GL_TEXTURE_2D, level, internalFormat, width, height, border, format, type, pixels );
        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP );
        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP );
        NW_GL_ASSERT();
    }

    if ( tex == 0 )
    {
        return false;
    }

    SetID( tex );
    SetTarget( GL_TEXTURE_2D );
    SetMipMapLevel( level );
    SetInternalFormat( internalFormat );
    SetWidth( width );
    SetHeight( height );
    SetBorderWidth( border );
    SetPixelFormat( format );
    SetDataType( type );

    return true;
}

} // namespace gfnd
} // namespace nw
