﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/types.h>
#include <nw/assert.h>

#include <nw/config.h>
#include <nw/font/font_DispStringBuffer.h>

namespace nw {
namespace font {

NW_STATIC_ASSERT(sizeof(internal::CharAttribute) == 48);

DispStringBuffer::DispStringBuffer(u32 charNum, void* graphicsBuffer, bool shadowEnabled)
: m_CharCountMax(charNum)
, m_CharCount(0)
, m_TextureUseInfoPos(0)
, m_CharAttrs(NULL)
, m_IsUseSharedCharAttrs(false)
, m_IsGeneratedCommand(false)
{
    u32 vertexBufferSize = internal::VERTEX_NUMBER_BY_LETTER * charNum;
    if (shadowEnabled) {
        vertexBufferSize *= 2;
    }
    internal::Vertex* vertexBuffer = static_cast<internal::Vertex*>(graphicsBuffer);
    for (int i = 0; i < VERTEX_BUFFER_QUANTITY; ++i)
    {
        this->GetVertexBuffers().SetBuffer(i, vertexBuffer);
        vertexBuffer += vertexBufferSize;
    }
}

}   // namespace font
}   // namespace nw
