﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/control/dw_TabControl.h>

namespace nw {
namespace internal {
namespace dw {

const Measurement TabControl::DEFAULT_MEASUREMENT = MEASUREMENT_MANUAL;
const f32 TabControl::DEFAULT_TAB_PANEL_WIDTH = 120.f;
const f32 TabControl::DEFAULT_TAB_PANEL_HEIGHT = 240.f;
const bool TabControl::DEFAULT_TAB_PANEL_IS_BORDERED = true;

//---------------------------------------------------------------------------
TabControl::TabControl()
 : m_TabsBordered( false ),
   m_TabsSelectedBackgroundColor( nw::ut::Color4f::X_TRANSPARENT() ),
   m_TabsBackgroundColor( nw::ut::Color4f::X_TRANSPARENT() ),
   m_TabsSelectedTextColor( nw::ut::Color4f::X_WHITE() ),
   m_TabsTextColor( nw::ut::Color4f::X_DARK_GRAY() ),
   m_CurrentTabIndex( 0 )
{
    SetIsFocusable(true);

    m_TabPanel.SetMeasurement( DEFAULT_MEASUREMENT );
    m_TabPanel.SetHeight( DEFAULT_TAB_PANEL_WIDTH );
    m_TabPanel.SetWidth( DEFAULT_TAB_PANEL_HEIGHT );
    m_TabPanel.SetIsBordered( DEFAULT_TAB_PANEL_IS_BORDERED );
}


//---------------------------------------------------------------------------
bool
TabControl::OnUpdateFocusedInput(const nw::internal::dw::Inputs& inputs)
{
    if(inputs.GetPad() == NULL)
    {
        return false;
    }

    const nw::dev::Pad& pad = *inputs.GetPad();

    if ( pad.IsHold( nw::dev::Pad::MASK_L ) )
    {
        if( pad.IsTrig( nw::dev::Pad::MASK_RIGHT ) || pad.IsRepeatAccel( nw::dev::Pad::MASK_RIGHT ) )
        {
            MoveSelection( 1 );
            return true;
        }

        if( pad.IsTrig( nw::dev::Pad::MASK_LEFT ) || pad.IsRepeatAccel( nw::dev::Pad::MASK_LEFT ) )
        {
            MoveSelection( -1 );
            return true;
        }
    }

    return false;
}

//---------------------------------------------------------------------------
void
TabControl::MoveSelection(s32 offset)
{
    if ( GetTabCount() == 0 )
    {
        return;
    }

    s32 newIndex = m_CurrentTabIndex + offset;

    if ( newIndex < 0 )
    {
        newIndex = ( m_CurrentTabIndex == 0 ? GetTabCount() - 1 : 0 );
    }

    if ( GetTabCount() <= newIndex )
    {
        newIndex = ( m_CurrentTabIndex == GetTabCount() - 1 ? 0 : GetTabCount() - 1 );
    }

    if ( newIndex == m_CurrentTabIndex )
    {
        return;
    }

    SelectTab( newIndex );
}

} /* namespace dw */
} /* namespace internal */
} /* namespace nw */
