﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/control/dw_Label.h>

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
#ifdef DrawText
#undef DrawText  // winuser.h で #define されているため #undef します。
#endif
#endif

namespace nw {
namespace internal {
namespace dw {

Label::Label() :
m_TextAlignment(TEXT_LEFT),
m_TextScale(1.f),
m_TextColor(nw::ut::Color4f::WHITE())
{
    SetIsFocusable(false);
    SetPadding(Thickness(2.f, 1.f, 1.f, 0.f));
}

void Label::SetText(const char* value)
{
    NW_ASSERT(value != NULL);
    SetText(value, ::strlen(value));
}

TextAlignment Label::GetTextAlignment() const
{
    return m_TextAlignment;
}

void Label::SetTextAlignment(TextAlignment value)
{
    m_TextAlignment = value;
}

f32 Label::GetTextScale() const
{
    return m_TextScale;
}

void Label::SetTextScale(f32 value)
{
    m_TextScale = value;
}

const nw::ut::Color4f& Label::GetTextColor() const
{
    return m_TextColor;
}

void Label::SetTextColor(const nw::ut::Color4f& value)
{
    m_TextColor = value;
}

const nw::math::Vector2 Label::OnMeasure(UIRenderer& renderer) const
{
    nw::math::Vector2 size = MeasureText(renderer);

    size.x += GetPadding().GetWidth();
    size.y += GetPadding().GetHeight();

    return size;
}

void Label::OnRender(const UIElementTreeContext& context, UIRenderer& renderer, UIElementRenderArgs& args) const
{
    (void)args;

    nw::math::Vector2 topLeft = GetContentAreaTopLeft();
    nw::math::Vector2 drawPosition = topLeft;

    if(m_TextAlignment != TEXT_LEFT)
    {
        nw::math::Vector2 textSize = MeasureText(renderer);
        nw::math::Vector2 size = GetContentAreaSize();

        switch(m_TextAlignment)
        {
        case TEXT_RIGHT:
            drawPosition.x = topLeft.x + size.x - textSize.x;
            break;

        case TEXT_CENTER:
            drawPosition.x = topLeft.x + (size.x - textSize.x) / 2;
            break;

        // TODO : 縦方向のアライメントは未実装です。

        default:
            break;
        }
    }

    renderer.DrawText(
        &context,
        DrawTextArgs().
            SetTopLeft(drawPosition).
            SetScale(m_TextScale).
            SetColor(m_TextColor),
        GetText());
}

const nw::math::Vector2 Label::MeasureText(UIRenderer& renderer) const
{
    return renderer.MeasureText(
        DrawTextArgs().SetScale(m_TextScale),
        GetText());
}

} // dw
} // internal
} // nw
