﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dev/dev_Resource.h>
#include <algorithm>

namespace nw
{
namespace dev
{
namespace internal
{

const int POINTER_ARROW_TEXTURE_WIDTH  = 16;
const int POINTER_ARROW_TEXTURE_HEIGHT = 24;
const int POINTER_ARROW_TEXTURE_SIZE = POINTER_ARROW_TEXTURE_WIDTH * POINTER_ARROW_TEXTURE_HEIGHT;

const u8 s_PointerDataArrow[POINTER_ARROW_TEXTURE_SIZE] =
{
    0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x42, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x42, 0xBA, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x42, 0xBA, 0xBA, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x42, 0xBA, 0xBA, 0xBA, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x42, 0xBA, 0xBA, 0xBA, 0xBA, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x42, 0xBA, 0xFF, 0xBA, 0xBA, 0xBA, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x42, 0xBA, 0xFF, 0xBA, 0xBA, 0xBA, 0xBA, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x42, 0xBA, 0xFF, 0xFF, 0xBA, 0xBA, 0xBA, 0xBA, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x42, 0xBA, 0xFF, 0xFF, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x42, 0xBA, 0xFF, 0xFF, 0xFF, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0x0F, 0x0F, 0x00, 0x00, 0x00,
    0x42, 0x42, 0xBA, 0xFF, 0xFF, 0xFF, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0x0F, 0x0F, 0x00, 0x00,
    0x42, 0x42, 0xBA, 0xFF, 0xFF, 0xFF, 0xFF, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0xBA, 0x0F, 0x0F, 0x00,
    0x42, 0x42, 0xBA, 0xFF, 0xFF, 0xFF, 0x42, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x42, 0x42, 0xBA, 0xFF, 0xFF, 0x42, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x42, 0x42, 0xBA, 0xFF, 0x42, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x42, 0xBA, 0x42, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x42, 0x42, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x42, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x42, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const PointerData s_PointerArrow =
{
    s_PointerDataArrow,
    POINTER_ARROW_TEXTURE_WIDTH,
    POINTER_ARROW_TEXTURE_HEIGHT,
    0,
    0
};

} // namespace internal

//--------------------------------------------------------------------------
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
u8*
CreatePointerTexture( nw::ut::IAllocator* allocator, PointerType type, nw::gfnd::TextureGL* texture )
{
    NW_ASSERT_NOT_NULL( allocator );
    NW_ASSERT_NOT_NULL( texture );

    u8* texImage = static_cast<u8*>( allocator->Alloc( POINTER_TEXTURE_DATA_SIZE ) );
    std::memset( texImage, 0, POINTER_TEXTURE_DATA_SIZE );

    const PointerData* pointerData = GetPointerData( type );

    for (int y = 0; y < pointerData->height; ++y)
    {
        for(int x = 0; x < pointerData->width; ++x)
        {
            u8 value = pointerData->data[pointerData->width * y + x];
            texImage[ (POINTER_TEXTURE_SIZE * y + x) * 4 + 0 ] = value;
            texImage[ (POINTER_TEXTURE_SIZE * y + x) * 4 + 1 ] = value;
            texImage[ (POINTER_TEXTURE_SIZE * y + x) * 4 + 2 ] = value;
            texImage[ (POINTER_TEXTURE_SIZE * y + x) * 4 + 3 ] = value == 0 ? 0 : 255;
        }
    }

    texture->CreateTextureImage2D( 0, GL_RGBA, POINTER_TEXTURE_SIZE, POINTER_TEXTURE_SIZE, 0, GL_RGBA, GL_UNSIGNED_BYTE, texImage );

    return texImage;
}

//--------------------------------------------------------------------------
#else
u8*
CreatePointerTexture( nw::ut::IAllocator* allocator, PointerType type, nw::gfnd::TextureCafeGX2* texture, GX2Texture* textureGX2 )
{
    NW_ASSERT_NOT_NULL( texture );
    NW_ASSERT_NOT_NULL( textureGX2 );

    GX2InitTexture(
        textureGX2,
        POINTER_TEXTURE_SIZE,   // width
        POINTER_TEXTURE_SIZE,   // height
        1,  // depth
        1,  // num mips
        GX2_SURFACE_FORMAT_TCS_R8_G8_B8_A8_UNORM,
        GX2_SURFACE_DIM_2D
        );

    textureGX2->surface.tileMode = GX2_TILE_MODE_LINEAR_ALIGNED;

    GX2CalcSurfaceSizeAndAlignment( &textureGX2->surface );
    GX2InitTextureRegs( textureGX2 );

    NW_ASSERT_NOT_NULL( allocator );
    u8* texImage = static_cast<u8*>( allocator->Alloc( textureGX2->surface.imageSize, textureGX2->surface.alignment ) );

    std::memset( texImage, 0, textureGX2->surface.imageSize );
    GX2InitTexturePtrs( textureGX2, texImage, 0 );

    const PointerData* pointerData = GetPointerData( type );

    for (int y = pointerData->height - 1; y >= 0; --y)
    {
        for(int x = 0; x < pointerData->width; ++x)
        {
            u8 value = pointerData->data[pointerData->width * y + x];
            texImage[ (textureGX2->surface.pitch * ( POINTER_TEXTURE_SIZE - y - 1 ) + x) * 4 + 0 ] = value;
            texImage[ (textureGX2->surface.pitch * ( POINTER_TEXTURE_SIZE - y - 1 ) + x) * 4 + 1 ] = value;
            texImage[ (textureGX2->surface.pitch * ( POINTER_TEXTURE_SIZE - y - 1 ) + x) * 4 + 2 ] = value;
            texImage[ (textureGX2->surface.pitch * ( POINTER_TEXTURE_SIZE - y - 1 ) + x) * 4 + 3 ] = value == 0 ? 0 : 255;
        }
    }

    GX2Invalidate(GX2_INVALIDATE_CPU_TEXTURE, textureGX2->surface.imagePtr, textureGX2->surface.imageSize);

    texture->SetGX2Texture( textureGX2 );

    return texImage;
}
#endif

//--------------------------------------------------------------------------
const PointerData*
GetPointerData(PointerType type)
{
    // TODO: POINTER_ARROW 以外も対応する。
    switch ( type )
    {
    case POINTER_ARROW:
        return &internal::s_PointerArrow;

    case POINTER_MOVE:
        NW_NOT_IMPLEMENTED();
        return NULL;

    case POINTER_RESIZE:
        NW_NOT_IMPLEMENTED();
        return NULL;

    default:
        break;
    }

    return NULL;
}

} // namespace dev
} // namespace nw

