﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#ifdef NW_SND_SPY_ENABLE

#include <nw/snd/spy/modules/sndspy_SpyModule.h>

// NN_TEXT() マクロにより日本語を埋め込めるようになるまで、C4566 を無効化
#if defined(NW_PLATFORM_WIN32)
#pragma warning( disable : 4566 )
#endif

namespace nw {
namespace snd {
namespace spy {

//----------------------------------------------------------
void SpyModule::Attach(SpyController& controller)
{
    NW_ASSERTMSG(m_Controller == NULL || m_Controller == &controller, "この SpyModule は、すでに他の SpyController にアタッチされています。");

    m_Controller = &controller;
    ++m_RegistCount;

    // このタイミング（初期化時）で、DataID を無効化し、
    // PC との接続のタイミングで有効な ID を割り当てます。
    AllocateDataID(DATA_ID_INVALID);
}


//----------------------------------------------------------
void SpyModule::Detach()
{
    if(m_RegistCount == 0)
    {
        NW_ASSERTMSG(false, "アタッチされていない SpyModule に対して、Detach() が呼び出されました。");
        return;
    }

    --m_RegistCount;

    if(m_RegistCount > 0)
    {
        return;
    }

    m_Controller = NULL;
    AllocateDataID(DATA_ID_INVALID);

    SetPrev(NULL);
    SetNext(NULL);
}

//----------------------------------------------------------
void SpyModule::AllocateDataID(SpyDataID dataID)
{
    GetDataInfo().SetDataID(dataID);
}

} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_SPY_ENABLE
