﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#ifdef NW_SND_SPY_ENABLE

#include <nw/snd/spy/fnd/string/sndspyfnd_String.h>
#include <nw/snd/spy/modules/sndspy_PlotGroup.h>
#include <nw/snd/spy/modules/sndspy_PlotModule.h>

// NN_TEXT() マクロにより日本語を埋め込めるようになるまで、C4566 を無効化
#if defined(NW_PLATFORM_WIN32)
#pragma warning( disable : 4566 )
#endif

namespace nw {
namespace snd {
namespace spy {

//------------------------------------------------------------------------------
PlotGroup::PlotGroup()
    : m_Module(NULL)
    , m_Prev(NULL)
    , m_Next(NULL)
    , m_IsMetadataPushed(false)
{
    InitializePacketCommonData();
}

//------------------------------------------------------------------------------
PlotGroup::PlotGroup(const char* name)
    : m_Module(NULL)
    , m_Prev(NULL)
    , m_Next(NULL)
    , m_IsMetadataPushed(false)
{
    InitializePacketCommonData();
    SetName(name);
}

//------------------------------------------------------------------------------
PlotGroup::~PlotGroup()
{
    if(IsAttached())
    {
        m_Module->DetachGroup(*this);
    }
}

//------------------------------------------------------------------------------
void PlotGroup::InitializePacketCommonData()
{
    std::memset(&m_MetadataPacketPayload, 0, sizeof(m_MetadataPacketPayload));
    m_MetadataPacketPayload.common.dataType = SpyPlotItemPacket::DataType_GroupMetadata;
    m_MetadataPacketPayload.id = reinterpret_cast<u32>(this);
}

//------------------------------------------------------------------------------
void PlotGroup::SetName(const char* name)
{
    if(IsRequested())
    {
        NW_WARNING(false, "通信中は、spy::PlotGroup の名前を変更できません。")
        return;
    }

    if(name == NULL)
    {
        NW_WARNING(false, "名前が指定されていません。");
        return;
    }

    m_MetadataPacketPayload.name.Set(name);
}

//------------------------------------------------------------------------------
void PlotGroup::Attach(PlotModule& module)
{
    NW_ASSERTMSG(m_Module == NULL || m_Module == &module, "この spy::PlotGroup は、すでに他の spy::PlotModule にアタッチされています。");

    m_Module = &module;
    InvalidateMetadata();
}

//------------------------------------------------------------------------------
void PlotGroup::Detach()
{
    m_Module = NULL;
    SetPrev(NULL);
    SetNext(NULL);
}

//------------------------------------------------------------------------------
void PlotGroup::PushMetadata()
{
    NW_ASSERT(IsRequested());

    if (!IsRequested())
    {
        return;
    }

    if(!m_Module->PushData(m_MetadataPacketPayload))
    {
        NW_WARNING(false, "spy::PlotGroup '%s' のデータ送信に失敗しました。", GetName());
    }

    m_IsMetadataPushed = true;
}

//------------------------------------------------------------------------------
void PlotGroup::PushDetachPacket()
{
    NW_ASSERT(IsRequested());

    if (!IsRequested())
    {
        return;
    }

    if (!IsMetadataPushed())
    {
        return;
    }

    SpyPlotItemPacket::GroupDetachPacketPayload payload = { 0 };
    payload.common.dataType = SpyPlotItemPacket::DataType_GroupDetach;
    payload.id = m_MetadataPacketPayload.id;

    if(!m_Module->PushData(payload))
    {
        NW_WARNING(false, "spy::PlotGroup '%s' のデータ送信に失敗しました。", GetName());
    }
}

} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_SPY_ENABLE
