﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// 以下を有効にすると、評価中の機能が有効化されます。
#define NW_SND_BUILD_ENABLE_SNDEDIT
#define NW_SND_BUILD_ENABLE_SNDCTRL

#include <nw/config.h>

#ifdef NW_SND_BUILD_ENABLE_SNDEDIT

    // sndedit sources
    #include "edit/sndedit_Types.cpp"
    #include "edit/sndedit_SoundEdit.cpp"
    #include "edit/sndedit_SoundEditSession.cpp"
    #include "edit/sndedit_SoundEditConnection.cpp"
    #include "edit/sndedit_SoundArchiveEditor.cpp"
    #include "edit/sndedit_SoundArchiveEditController.cpp"
    #include "edit/sndedit_SoundArchiveFileEditor.cpp"
    #include "edit/sndedit_SoundArchiveParameterEditor.cpp"
    #include "edit/hio/sndedit_HioChannel.cpp"
    #include "edit/hio/sndedit_HioAsyncChannel.cpp"
    #include "edit/hio/sndedit_HioManager.cpp"
    #include "edit/hio/sndedit_HioPacketStream.cpp"
    #include "edit/hio/sndedit_HioMessageHandler.cpp"
    #include "edit/handler/sndedit_SyncReplyHandler.cpp"
    #include "edit/handler/sndedit_QueryItemsReplyHandler.cpp"
    #include "edit/res/sndedit_CacheManager.cpp"
    #include "edit/res/sndedit_ResourceManager.cpp"
    #include "edit/util/sndedit_UpdateCachesHelper.cpp"
    #include "edit/util/sndedit_PatriciaDictionary.cpp"

    #if defined(NW_PLATFORM_CAFE)
        #include "edit/Cafe/sndedit_SoundArchiveEditControllerCafe.cpp"
        #include "edit/Cafe/sndedit_SoundEditSessionCafe.cpp"
        #include "edit/Cafe/sndedit_SoundEditConnectionCafe.cpp"
        #include "edit/hio/Cafe/sndedit_HioManagerCafe.cpp"
        #include "edit/hio/Cafe/sndedit_HioStreamCafe.cpp"
    #elif defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
        #include "edit/Win/sndedit_SoundArchiveEditControllerWin.cpp"
        #include "edit/Win/sndedit_SoundEditSessionWin.cpp"
        #include "edit/Win/sndedit_SoundEditConnectionWin.cpp"
        #include "edit/hio/Win/sndedit_HioManagerWin.cpp"
        #include "edit/hio/Win/sndedit_HioStreamWin.cpp"
    #else
        #error
    #endif

    // windows.h に関する諸問題があるため、
    // (winSock2.h を先にインクルードする必要がある、min, max が置換される)
    // windows.h をインクルードしているこの cpp を一番最後にインクルードする
    #include "edit/hio/sndedit_HioSyncChannel.cpp"

#endif

#ifdef NW_SND_BUILD_ENABLE_SNDCTRL

    // sndctrl sources
    #include "ctrl/sndctrl_SoundControllerImpl.cpp"
    #include "ctrl/sndctrl_SoundControlSession.cpp"
    #include "ctrl/sndctrl_SoundObjectController.cpp"
    #include "ctrl/sndctrl_SequenceVariable.cpp"
    #include "ctrl/handler/sndctrl_PlaySoundHandler.cpp"
    #include "ctrl/handler/sndctrl_StopSoundHandler.cpp"
    #include "ctrl/handler/sndctrl_PauseSoundHandler.cpp"

    #if defined(NW_PLATFORM_CAFE)
        #include "ctrl/Cafe/sndctrl_SoundControllerImplCafe.cpp"
        #include "ctrl/Cafe/sndctrl_SoundControlSessionCafe.cpp"
    #elif defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
        #include "ctrl/Win/sndctrl_SoundControllerImplWin.cpp"
        #include "ctrl/Win/sndctrl_SoundControlSessionWin.cpp"
    #else
        #error
    #endif

#endif
