﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/edit/hio/sndedit_HioMessageHandler.h>

#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/snd/edit/hio/sndedit_HioChannel.h>
#include <nw/snd/edit/hio/sndedit_HioPacketStream.h>

namespace nw {
namespace snd {
namespace edit {
namespace internal {

//---------------------------------------------------------------------------
HioResult
HioMessageHandler::Invoke(HioPacketStream& stream)
{
    if(!CanRespond(*stream.GetReadHeader()))
    {
#if !defined(NW_RELEASE)
        NW_WARNING(
            false,
            "%s(0x%08x) is not invoked.",
            stream.GetReadHeader()->message.ToString(),
            u32(stream.GetReadHeader()->message));
#endif
        return HioResult(HIO_RESULT_FALSE);
    }

    HioResult result = OnInvoke(stream);

    return result;
}

//---------------------------------------------------------------------------
HioResult
HioMessageHandler::OnInvoke(HioPacketStream& stream)
{
    HioResult result = stream.TryReadBody();

    if(!result.IsTrue())
    {
        return result;
    }

    return OnInvokeForReadPacket(*stream.GetReadPacket(), stream);
}

//---------------------------------------------------------------------------
HioResult
HioMessageHandler::OnInvokeForReadPacket(const HioPacket& packet, HioPacketStream& stream)
{
    (void)packet;
    (void)stream;

    NW_FATAL_ERROR("HioMessageHandler::OnInvokeForReadPacket() is not implemented.\n");
    return HioResult(HIO_RESULT_TARGET_NOT_IMPLEMENTED);
}

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV
