﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/types.h>
#include <nw/snd/dw/system/snddw_Allocator.h>

#if defined( NW_PLATFORM_WIN32 )
using namespace nw::internal::winext;
#endif

namespace nw {
namespace snd {
namespace dw {
namespace internal {

//------------------------------------------------------------------------------
Allocator::Allocator()
{
}

//------------------------------------------------------------------------------
Allocator::~Allocator()
{
}

//------------------------------------------------------------------------------
void
Allocator::Initialize(void* startAddress, size_t size, u16 option)
{
    m_HeapHandle = MEMCreateExpHeapEx(startAddress, size, option);
}

//------------------------------------------------------------------------------
void
Allocator::Finalize()
{
    MEMDestroyExpHeap(m_HeapHandle);
}

//------------------------------------------------------------------------------
void*
Allocator::GetStartAddress()
{
    return MEMGetHeapStartAddress(m_HeapHandle);
}

//------------------------------------------------------------------------------
void*
Allocator::GetEndAddress()
{
    return MEMGetHeapEndAddress(m_HeapHandle);
}

//------------------------------------------------------------------------------
void*
Allocator::Alloc(size_t size, u32 alignment)
{
    void* memory = MEMAllocFromExpHeapEx(m_HeapHandle, size, alignment);

    NW_ASSERTMSG(
        memory != NULL,
        "[Allocation Failed] require:%d(align:%d), but allocatable:%d(free:%d)\n",
        size,
        alignment,
        GetAllocatableSize(alignment),
        GetFreeSize()
    );

    return memory;
}

//------------------------------------------------------------------------------
void
Allocator::Free(void* memory)
{
    MEMFreeToExpHeap(m_HeapHandle, memory);
}

//------------------------------------------------------------------------------
size_t
Allocator::GetFreeSize()
{
    return MEMGetTotalFreeSizeForExpHeap(m_HeapHandle);
}

//------------------------------------------------------------------------------
size_t
Allocator::GetTotalSize()
{
    return MEMGetHeapTotalSize(m_HeapHandle);
}

//------------------------------------------------------------------------------
size_t
Allocator::GetMemoryBlockSize(void* address)
{
    return MEMGetSizeForMBlockExpHeap(address);
}

//------------------------------------------------------------------------------
size_t
Allocator::GetAllocatableSize(u32 alignment)
{
    return MEMGetAllocatableSizeForExpHeapEx(m_HeapHandle, alignment);
}

//------------------------------------------------------------------------------
void
Allocator::Dump()
{
    MEMDumpHeap(m_HeapHandle);
}

} // namespace internal
} // namespace dw
} // namespace snd
} // namespace nw
