﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_StreamSoundHandle.h>
#include <nw/snd/snd_SoundHandle.h>

namespace nw {
namespace snd {

StreamSoundHandle::StreamSoundHandle( SoundHandle* pHandle )
: m_pSound( NULL )
{
    if ( pHandle == NULL ) return;

    // 汎用ハンドルからサウンドを取得
    if ( !pHandle->IsAttachedSound() ) return;

    internal::StreamSound* sound =
        ut::DynamicCast<internal::StreamSound*>( pHandle->detail_GetAttachedSound() );

    if ( sound != NULL )
    {
        // シーケンスサウンドなら一時ハンドルとしてAttachする
        detail_AttachSoundAsTempHandle( sound );
    }
}

/*---------------------------------------------------------------------------*
  Name:         detail_AttachSoundAsTempHandle

  Description:  ハンドルにサウンドを関連付ける

  Arguments:    sound - 関連付けるサウンド

  Returns:      None.
 *---------------------------------------------------------------------------*/
void StreamSoundHandle::detail_AttachSoundAsTempHandle( internal::StreamSound* pSound )
{
    NW_NULL_ASSERT( pSound );

    m_pSound = pSound;

    // 一時ハンドルとしてAttachする
    if ( m_pSound->IsAttachedTempSpecialHandle() )
    {
        m_pSound->DetachTempSpecialHandle();
    }
    m_pSound->m_pTempSpecialHandle = this;
}

/*---------------------------------------------------------------------------*
  Name:         DetachSound

  Description:  ハンドルに結びついているサウンドの関連を外す

  Arguments:    None.

  Returns:      None.
 *---------------------------------------------------------------------------*/
void StreamSoundHandle::DetachSound()
{
    if ( IsAttachedSound() )
    {
        if ( m_pSound->m_pTempSpecialHandle == this ) m_pSound->m_pTempSpecialHandle = NULL;
    }
    if ( m_pSound != NULL ) m_pSound = NULL;
}

} // namespace nw::snd
} // namespace nw

