﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_ProfileReader.h>
#include <nw/snd/snd_Config.h>

namespace nw {
namespace snd {

// ----------------------------------------------------------------------------------
ProfileReader::ProfileReader()
: m_ProfileBufferWrite(0),
  m_ProfileBufferRead(0)
{
}

// ----------------------------------------------------------------------------------
int ProfileReader::Read( SoundProfile* profile, int maxCount )
{
    int count = 0;
    while( m_ProfileBufferRead != m_ProfileBufferWrite && count < maxCount ) {
        profile[count] = m_ProfileBuffer[m_ProfileBufferRead];
        m_ProfileBufferRead++;
        if ( m_ProfileBufferRead >= internal::MAX_PROFILE_COUNT ) {
            m_ProfileBufferRead = 0;
        }
        count++;
    }
    return count;
}

// ----------------------------------------------------------------------------------
void ProfileReader::Record( const SoundProfile& src )
{
    SoundProfile& dst = m_ProfileBuffer[m_ProfileBufferWrite];

    dst = src;

    m_ProfileBufferWrite++;
    if ( m_ProfileBufferWrite >= internal::MAX_PROFILE_COUNT ) {
        m_ProfileBufferWrite = 0;
    }
}

} // namespace nw::snd
} // namespace nw

