﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_DspadpcmReader.h>
#include <nw/config.h>
#include <nw/ut/ut_Inlines.h>

#if defined( NW_PLATFORM_CAFE )
    #include <cafe/ax.h>
    typedef DSPADPCM InternalDSPADPCMInfo;
#elif defined( NW_PLATFORM_WIN32 )
    struct InternalDSPADPCMInfo
    {
        // for header generation during decode
        u32 num_samples;       // total number of RAW samples
        u32 num_adpcm_nibbles; // number of ADPCM nibbles (including frame headers)
        u32 sample_rate;       // Sample rate, in Hz

        // DSP addressing and decode context
        u16 loop_flag;    // 1=LOOPED, 0=NOT LOOPED
        u16 format;       // Always 0x0000, for ADPCM
        u32 sa;           // Start offset address for looped samples (2 for non-looped)
        u32 ea;           // End offset address for looped samples
        u32 ca;           // always 2
        u16 coef[16];     // decode coefficients (eight pairs of 16-bit words)

        // DSP decoder initial state
        u16 gain;         // always zero for ADPCM
        u16 ps;           // predictor/scale
        u16 yn1;          // sample history
        u16 yn2;          // sample history

        // DSP decoder loop context
        u16 lps;          // predictor/scale for loop context
        u16 lyn1;         // sample history (n-1) for loop context
        u16 lyn2;         // sample history (n-2) for loop context

        u16 pad[11];      // reserved
    };
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
// TODO: スマートデバイスのリトルエンディアン対応
struct InternalDSPADPCMInfo
{
    // for header generation during decode
    nw::ut::ResU32 num_samples;       // total number of RAW samples
    nw::ut::ResU32 num_adpcm_nibbles; // number of ADPCM nibbles (including frame headers)
    nw::ut::ResU32 sample_rate;       // Sample rate, in Hz

    // DSP addressing and decode context
    nw::ut::ResU16 loop_flag;    // 1=LOOPED, 0=NOT LOOPED
    nw::ut::ResU16 format;       // Always 0x0000, for ADPCM
    nw::ut::ResU32 sa;           // Start offset address for looped samples (2 for non-looped)
    nw::ut::ResU32 ea;           // End offset address for looped samples
    nw::ut::ResU32 ca;           // always 2
    nw::ut::ResU16 coef[16];     // decode coefficients (eight pairs of 16-bit words)

    // DSP decoder initial state
    nw::ut::ResU16 gain;         // always zero for ADPCM
    nw::ut::ResU16 ps;           // predictor/scale
    nw::ut::ResU16 yn1;          // sample history
    nw::ut::ResU16 yn2;          // sample history

    // DSP decoder loop context
    nw::ut::ResU16 lps;          // predictor/scale for loop context
    nw::ut::ResU16 lyn1;         // sample history (n-1) for loop context
    nw::ut::ResU16 lyn2;         // sample history (n-2) for loop context

    nw::ut::ResU16 pad[11];      // reserved
};
#else
    #error
#endif

namespace nw {
namespace snd {
namespace internal {

DspadpcmReader::DspadpcmReader()
: m_pDspadpcmData( NULL )
{
}

bool DspadpcmReader::ReadWaveInfo(WaveInfo* info) const
{
    NW_ASSERT_NOT_NULL(info);
    const InternalDSPADPCMInfo& data = *reinterpret_cast<const InternalDSPADPCMInfo*>(m_pDspadpcmData);

    info->sampleFormat = SAMPLE_FORMAT_DSP_ADPCM;
    info->loopFlag = false; // ループ未対応。対応時は、data.loop_flag == 1 ? true : false; とする。
    info->channelCount = 1;
    info->sampleRate = data.sample_rate;
    info->loopStartFrame = 0;
    info->loopEndFrame = data.num_samples;

    // dspadpcm はモノラル波形しか出力しない
    info->channelParam[0].dataAddress = ut::AddOffsetToPtr(m_pDspadpcmData, sizeof(InternalDSPADPCMInfo));
    std::memcpy(info->channelParam[0].adpcmParam.coef, &data.coef, sizeof(u16)*16);
    std::memcpy(&info->channelParam[0].adpcmParam.predScale, &data.ps, sizeof(u16)*3);

    return true;
}

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

