﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/fnd/basis/sndfnd_Time.h>

#include <nn/fnd/fnd_DateTime.h>

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

//----------------------------------------------------------
TimeSpan
Time::Current()
{
    nn::fnd::DateTime baseTime;
    nn::fnd::TimeSpan span = nn::fnd::DateTime::GetNow() - baseTime;
    return TimeSpan(span.GetNanoSeconds());
}

//----------------------------------------------------------
TimeSpan
TimeSpan::FromNanoSeconds(s64 value)
{
    return TimeSpan(value);
}

//----------------------------------------------------------
TimeSpan
TimeSpan::FromMicroSeconds(s64 value)
{
    return TimeSpan(nn::fnd::TimeSpan::FromMicroSeconds(value).GetNanoSeconds());
}

//----------------------------------------------------------
TimeSpan
TimeSpan::FromMilliSeconds(s64 value)
{
    return TimeSpan(nn::fnd::TimeSpan::FromMilliSeconds(value).GetNanoSeconds());
}

//----------------------------------------------------------
s64
TimeSpan::ToNanoSeconds() const
{
    return m_TickSpan;
}

//----------------------------------------------------------
s64
TimeSpan::ToMicroSeconds() const
{
    return nn::fnd::TimeSpan::FromNanoSeconds(m_TickSpan).GetMicroSeconds();
}

//----------------------------------------------------------
s64
TimeSpan::ToMilliSeconds() const
{
    return nn::fnd::TimeSpan::FromNanoSeconds(m_TickSpan).GetMilliSeconds();
}

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw
