﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/vwrlyt/win/vwrlyt_ScreenShotWin.h>

#if defined(NW_VWRLYT_ENABLE)

namespace nw
{
namespace vwrlyt
{

void ScreenShot::Prepare(ut::IAllocator* allocator)
{
    NW_ASSERT_NOT_NULL(allocator);

    if (m_state == cState_ReadyToTake)
    {
        NW_WARNING(false, "already prepared\n");
        return;
    }

    m_Buffer = allocator->Alloc<u8>(m_width * m_height * cPixelSize);
    m_state = cState_ReadyToTake;
}

void ScreenShot::Take()
{
    if (m_state != cState_ReadyToTake)
    {
        NW_WARNING(false, "not ready to take\n");
        return;
    }

    glFinish();
    glReadPixels(0, 0, m_width, m_height, GL_RGBA, GL_UNSIGNED_BYTE, m_Buffer);

    BITMAPFILEHEADER fileHeader;
    memset(&fileHeader, 0, sizeof(fileHeader));
    memcpy(&fileHeader.bfType, "BM", 2);
    fileHeader.bfSize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + m_width * m_height * cPixelSize;
    fileHeader.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);

    BITMAPINFOHEADER infoHeader;
    memset(&infoHeader, 0, sizeof(infoHeader));
    infoHeader.biSize = sizeof(infoHeader);
    infoHeader.biWidth = m_width;
    infoHeader.biHeight = m_height;
    infoHeader.biPlanes = 1;
    infoHeader.biBitCount = cPixelSize * 8;
    infoHeader.biCompression = BI_RGB;
    infoHeader.biSizeImage = m_width * m_height * cPixelSize;
    infoHeader.biXPelsPerMeter = 3780; // 96dpi
    infoHeader.biYPelsPerMeter = 3780; // 96dpi
    infoHeader.biClrUsed = 0;
    infoHeader.biClrImportant = 0;

    for (u32 y = 0; y < m_height; ++y)
    {
        for (u32 x = 0; x < m_width; ++x)
        {
            u8* pixel = m_Buffer + (y * m_width + x) * cPixelSize;

            // BMPのピクセルは Blue, Green, Red, Reserved(0) の順
            u8 r = pixel[0];
            u8 b = pixel[2];
            pixel[0] = b;
            pixel[2] = r;
            pixel[3] = 0;
        }
    }

    FILE* fp = NULL;

    if (fopen_s(&fp, m_fileName, "wb") == 0)
    {
        fwrite(&fileHeader, sizeof(fileHeader), 1, fp);
        fwrite(&infoHeader, sizeof(infoHeader), 1, fp);
        fwrite(m_Buffer, 1, m_width * m_height * cPixelSize, fp);

        fclose(fp);
    }
    else
    {
        NW_ERR("can not create screenshot (%s).", m_fileName);
    }

    delete[] m_Buffer;
    m_Buffer = NULL;
    m_state = cState_Done;
}

} // namespace vwrlyt
} // namespace nw

#endif // NW_VWRLYT_ENABLE
