﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/ctrl/ctrl_ButtonGroup.h>
#include <nw/lyt/lyt_Common.h>
#include <nw/lyt/lyt_Layout.h>

namespace nw
{
namespace ctrl
{

ButtonGroup::ButtonGroup()
 : m_HitButton(NULL)
 , m_DraggingButton(NULL)
 , m_Flag(MASK_UPDATE_HIT_BOX | MASK_EXCLUDE_DOWN | MASK_HIT_TEST_ENABLE)
{
}

ButtonGroup::~ButtonGroup()
{
}

void ButtonGroup::Update(const math::VEC2* pos, bool isDown, bool isRelease /* = false */)
{
    // 当たりの領域の更新
    if (IsUpdateHitBox()) {
        ButtonList::Iterator it_end = m_ButtonList.GetEndIter();
        for (ButtonList::Iterator it = m_ButtonList.GetBeginIter(); it != it_end; ++it)
        {
            it->UpdateHitBox();
        }
    }

    {
        AnimButton* hitButton = NULL;
        bool is_exclude_down = false;
        if (IsExcludeDown()) {
            // ボタンの中から、押されたときに他のボタンが押されるのを防ぐ設定になっていて、
            // かつ現在押されているボタンを探し、もしあったらこのフレームボタンには当たり
            // が発生しないようにする。
            ButtonList::Iterator it_end = m_ButtonList.GetEndIter();
            for (ButtonList::Iterator it = m_ButtonList.GetBeginIter(); it != it_end; ++it)
            {
                if (it->IsExcludeDown() && it->IsDowning())
                {
                    is_exclude_down = true;
                    break;
                }
            }
        }

        if (m_DraggingButton) {
            if (IsHitTestEnable() && ! is_exclude_down && pos) {
                if (m_DraggingButton->IsActive() && m_DraggingButton->HitTest(*pos)) {
                    hitButton = m_DraggingButton;
                }
            }
            m_DraggingButton->UpdateDragPosition(pos);
            if (isRelease) {
                m_DraggingButton->Cancel();
                if (hitButton != m_DraggingButton) {
                    m_DraggingButton->Off();
                }
                m_DraggingButton = NULL;
            }
        } else {
            if (IsHitTestEnable() && ! is_exclude_down && pos) {
                ButtonList::Iterator it_end = m_ButtonList.GetEndIter();
                for (ButtonList::Iterator it = m_ButtonList.GetBeginIter(); it != it_end; ++it) {
                    if (it->IsActive() && it->HitTest(*pos)) {
                        hitButton = &(*it);
                        break;
                    }
                }
            }
        }

        if (m_HitButton != hitButton) {
            if (m_HitButton) {
                m_HitButton->Off();
            }
            if (hitButton) {
                hitButton->On();
            }
            m_HitButton = hitButton;
        }

        if (m_HitButton) {
            bool isDownActually = ( ! is_exclude_down && isDown);
            if (isDownActually) {
                m_HitButton->Down();
            }
            AnimButton::DragMode dragMode = m_HitButton->GetDragMode();
            if ((dragMode == AnimButton::DRAG_MODE_ON_HIT || (dragMode == AnimButton::DRAG_MODE_ON_DOWN && isDownActually)) && m_DraggingButton == NULL && ! isRelease) {
                m_DraggingButton = m_HitButton;
                m_DraggingButton->InitDragPosition(*pos);
            }
        }
    }

    // 状態の更新
    {
        ButtonList::Iterator it_end = m_ButtonList.GetEndIter();
        for (ButtonList::Iterator it = m_ButtonList.GetBeginIter(); it != it_end; ++it)
        {
            it->Update();
        }
    }
}

AnimButton* ButtonGroup::FindDownButton()
{
    ButtonList::Iterator it_end = m_ButtonList.GetEndIter();
    for (ButtonList::Iterator it = m_ButtonList.GetBeginIter(); it != it_end; ++it)
    {
        if (it->IsDowning()) {
            return &(*it);
        }
    }
    return NULL;
}

AnimButton* ButtonGroup::FindButtonByName(const char* buttonName)
{
    ButtonList::Iterator it_end = m_ButtonList.GetEndIter();
    for (ButtonList::Iterator it = m_ButtonList.GetBeginIter(); it != it_end; ++it)
    {
        if (lyt::internal::EqualsLayoutName(buttonName, it->GetName())) {
            return &(*it);
        }
    }
    return NULL;
}

AnimButton* ButtonGroup::FindButtonByNameReverse(const char* buttonName)
{
    ButtonList::ReverseIterator it_end = m_ButtonList.GetEndReverseIter();
    for (ButtonList::ReverseIterator it = m_ButtonList.GetBeginReverseIter(); it != it_end; ++it)
    {
        if (lyt::internal::EqualsLayoutName(buttonName, it->GetName())) {
            return &(*it);
        }
    }
    return NULL;
}

AnimButton* ButtonGroup::FindButtonByTag(int tag)
{
    ButtonList::Iterator it_end = m_ButtonList.GetEndIter();
    for (ButtonList::Iterator it = m_ButtonList.GetBeginIter(); it != it_end; ++it)
    {
        if (tag == it->GetTag()) {
            return &(*it);
        }
    }
    return NULL;
}

void ButtonGroup::ForceOffAll()
{
    ButtonList::Iterator it_end = m_ButtonList.GetEndIter();
    for (ButtonList::Iterator it = m_ButtonList.GetBeginIter(); it != it_end; ++it)
    {
        it->ForceOff();
    }
}

void ButtonGroup::ForceOnAll()
{
    ButtonList::Iterator it_end = m_ButtonList.GetEndIter();
    for (ButtonList::Iterator it = m_ButtonList.GetBeginIter(); it != it_end; ++it)
    {
        it->ForceOn();
    }
}

void ButtonGroup::ForceDownAll()
{
    ButtonList::Iterator it_end = m_ButtonList.GetEndIter();
    for (ButtonList::Iterator it = m_ButtonList.GetBeginIter(); it != it_end; ++it)
    {
        it->ForceDown();
    }
}

void ButtonGroup::UpdateHitBoxAll()
{
    ButtonList::Iterator it_end = m_ButtonList.GetEndIter();
    for (ButtonList::Iterator it = m_ButtonList.GetBeginIter(); it != it_end; ++it)
    {
        it->UpdateHitBox();
    }
}

void ButtonGroup::SetStateChangeCallbackAll(AnimButton::StateChangeCallback callback, void* param)
{
    ButtonList::Iterator it_end = m_ButtonList.GetEndIter();
    for (ButtonList::Iterator it = m_ButtonList.GetBeginIter(); it != it_end; ++it)
    {
        it->SetStateChangeCallback(callback, param);
    }
}

void ButtonGroup::CancelAll()
{
    ButtonList::Iterator it_end = m_ButtonList.GetEndIter();
    for (ButtonList::Iterator it = m_ButtonList.GetBeginIter(); it != it_end; ++it)
    {
        it->Cancel();
    }
}

void ButtonGroup::FreeAll()
{
    for (ButtonList::Iterator it = m_ButtonList.GetBeginIter(); it != m_ButtonList.GetEndIter();)
    {
        ButtonList::Iterator currIt = it++;
        m_ButtonList.Erase(currIt);
        lyt::Layout::DeleteObj(&(*currIt));
    }
}

} // namespace nw::ctrl
} // namespace nw
