﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_WINEXT_STL_H__
#define NW_WINEXT_STL_H__

#include <string>
#include <vector>
#include <map>
#include <deque>

namespace pcsdk {

//========================
// STL用のカスタムアロケータ
//  アプリケーション独自の operator new が定義されていた場合の回避用です。
//========================
template <typename T>
class allocator : public std::allocator<T>
{
public:
    template <class U> struct rebind { typedef allocator<U> other; };

    /* ctor */ allocator() {}
    /* ctor */ allocator(const allocator&){}
    /* ctor */ template <class U> allocator(const allocator<U>&) {}
    /* ctor */ template <class U> allocator& operator=(const allocator<U>&) {}

    typename std::allocator<T>::pointer allocate(typename std::allocator<T>::size_type n, typename std::allocator<T>::const_pointer = 0)
    {
        return static_cast<typename std::allocator<T>::pointer>( std::malloc( u32( n * sizeof(T) ) ) );
    }

    void    deallocate(typename std::allocator<T>::pointer p, typename std::allocator<T>::size_type) { std::free( p ); }
};

template <class T, class U>
inline bool
operator==(const allocator<T>&, const allocator<U>&)
{ return true; }

template <class T, class U>
inline bool
operator!=(const allocator<T>&, const allocator<U>&)
{ return false; }

typedef ::std::basic_string< char, std::char_traits<char>, ::pcsdk::allocator<char> > string;

template <typename T>
struct vector
{
    typedef ::std::vector< T, ::pcsdk::allocator<T> > type;
    typedef typename ::std::vector< T, ::pcsdk::allocator<T> >::iterator iterator;
};

template <typename Key, typename T>
struct map
{
    typedef ::std::map< Key, T, std::less<Key>, ::pcsdk::allocator< std::pair<const Key, T> > > type;
    typedef typename ::std::map< Key, T, std::less<Key>, ::pcsdk::allocator< std::pair<const Key, T> > >::iterator iterator;
};

template <typename Key, typename T>
struct pair
{
    typedef ::std::pair< Key, T > type;
};

template <typename T>
struct deque
{
    typedef ::std::deque< T, ::pcsdk::allocator<T> > type;
    typedef typename ::std::deque< T, ::pcsdk::allocator<T> >::iterator iterator;
};

} // namespace pcsdk


#endif // NW_WINEXT_STL_H__
