﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_WINEXT_MEM_DEFAULTHEAP_H_INCLUDED_
#define NW_WINEXT_MEM_DEFAULTHEAP_H_INCLUDED_

#include <winext/cafe/os.h>
#include <winext/cafe/mem/heapCommon.h>

namespace nw {
namespace internal {
namespace winext {

#if 0
extern u8 * MEMUserHeapBase;
extern u32  MEMUserHeapSize;

typedef void * (*pfMEMAllocFromDefaultHeap)(u32 size);
typedef void * (*pfMEMAllocFromDefaultHeapEx)(u32 size, int alignment);
typedef void   (*pfMEMFreeToDefaultHeap)(void* memBlock);

void CoreInitDefaultHeap(MEMHeapHandle *aMEM1_heap, MEMHeapHandle *aMEMFG_heap, MEMHeapHandle *aMEM2_heap);
// The default user heap initialization done in coreinit is CoreInitDefaultHeap.
// CoreInitDefaultHeap is used by the loader to allocate the data area memory
// space used by RPLs imported by the RPX.
// CoreInitDefaultHeap returns via the parameters the MEM_ARENA_1, MEM_ARENA_FG, and
// MEM_ARENA_2 heaps in that order and will return all 3 for a game.

void __preinit_user(MEMHeapHandle *aMEM1_heap, MEMHeapHandle *aMEMFG_heap, MEMHeapHandle *aMEM2_heap);
// The game's user heap initialization done in the RPX:
// If symbol __preinit_user is not present in the RPX, the initialization
// done in CoreInitDefaultHeap() continues to be used for the default (MEM2) heap.
// __preinit_user receives via the parameters the MEM_ARENA_1, MEM_ARENA_FG, and
// MEM_ARENA_2 heaps in that order.  __preinit_user can change the handle of any or none
// of the heaps.  The ones __preinit_user does not change will use the version defined
// by CoreInitDefaultHeap.
// __preinit_user can be used to set up diagnostics and anything else that is needed
// before rpl entrypoints and C++ static constructors are called.

// The following variables are assigned in CoreInitDefaultHeap()
// and can be reassigned in an RPX in __preinit_user().
extern pfMEMAllocFromDefaultHeap MEMAllocFromDefaultHeap;
extern pfMEMAllocFromDefaultHeapEx MEMAllocFromDefaultHeapEx;
extern pfMEMFreeToDefaultHeap  MEMFreeToDefaultHeap;
#else
// application can replace these.  Implemenation weakly defined in MEM library.
MEMHeapHandle MEMInitDefaultHeap (void* startAddress, u32 size);
void* MEMAllocFromDefaultHeap (u32 size);
void* MEMAllocFromDefaultHeapEx (u32 size, int alignment);
void  MEMFreeToDefaultHeap (void* memBlock);
#endif

MEMHeapHandle MEMCreateUserHeapHandle(void* startAddress, u32 size);

} // namespace winext
} // namespace internal
} // namespace nw

#endif  /* NW_WINEXT_MEM_DEFAULTHEAP_H_INCLUDED_ */
