﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_VWRLYT_DIR_RESOURCE_ACCESSOR_WIN_H_
#define NW_VWRLYT_DIR_RESOURCE_ACCESSOR_WIN_H_

#include <nw/vwrlyt/vwrlyt_Config.h>
#if defined(NW_VWRLYT_ENABLE)

#include <cstddef>
#include <string>
#include <nw/types.h>
#include <nw/ut/ut_LinkList.h>

#include <nw/lyt/lyt_ResourceAccessor.h>

namespace nw
{
namespace vwrlyt
{

class DirResourceAccessor : public lyt::ResourceAccessor
{
public:
    //! 実行時型情報です。
    NW_UT_RUNTIME_TYPEINFO(lyt::ResourceAccessor);

    static DirResourceAccessor* Create(const char* pBasePath = "");

    // 指定したパス以下のリソースをアクセサに関連付けます。
    virtual void Attach(const char* resPath) = 0;

    // アクセサに関連づけられたリソースを破棄します。
    virtual void Detach() = 0;

    // リソースの関連づけが行われているか調べます。
    virtual bool IsAttached() const = 0;

    // 関連付けられたリソースのパスを取得します。
    virtual const char* GetResourceBasePath() const = 0;

    // 指定したリソースタイプのファイル名を得る。
    virtual const char* FindFile(
        lyt::ResType resType,
        const char* pPrevFileName) = 0;
};

} // namespace vwrlyt
} // namespace nw

#endif // NW_VWRLYT_ENABLE
#endif // NW_VWRLYT_DIR_RESOURCE_ACCESSOR_WIN_H_
