﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_VWRLYT_ANIMATION_MANAGER_H_
#define NW_VWRLYT_ANIMATION_MANAGER_H_

#include <nw/vwrlyt/vwrlyt_Config.h>
#if defined(NW_VWRLYT_ENABLE)

#include <nw/lyt.h>
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
#include <nw/vwrlyt/win/vwrlyt_DirResourceAccessorWin.h>
#endif
#if defined(NW_PLATFORM_CAFE)
#include <nw/vwrlyt/cafe/vwrlyt_FindableArcResourceAccessorCafe.h>
#endif
#include <nw/ut.h>
#include <nw/ut/ut_SafeString.h>

namespace nw
{
namespace vwrlyt
{

class AnimationManager
{
public:
    enum TargetMode
    {
        TARGET_MODE_PANE,
        TARGET_MODE_GROUP,
    };

    AnimationManager();

    void Setup(
        lyt::Layout* layout,
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
        vwrlyt::DirResourceAccessor* resourceAccessor
#elif defined(NW_PLATFORM_CAFE)
        vwrlyt::FindableArcResourceAccessor* resourceAccessor
#endif
    );

    void Finalize();

    u32 GetAnimationNum() const;

    u32 GetCurrentAnimationNo() const;

    const char* GetCurrentAnimationName() const
    {
        return m_CurrentAnimationName.c_str();
    }

    TargetMode GetTargetMode() const
    {
        return m_TargetMode;
    }

    void SetTargetMode(TargetMode mode);

    void SetCurrentAnimationNo(u32 no);

    u32 GetCurrentTargetNum();

    u32 GetCurrentTargetNo() const
    {
        return m_CurrentTargetNo;
    }

    const char* GetCurrentTargetName() const
    {
        return m_CurrentTargetName;
    }

    void SetCurrentTargetNo(u32 no);

    lyt::Animator* GetAnimator()
    {
        return m_Animator;
    }

    ///--- アニメのコントロール
    bool IsCurrentAnimationLoop() const;

    void StartAnimation();

    void StopAnimation();

    void ResetAnimation();

    bool IsAnimationPlaying() const;

    f32 GetCurrentAnimationFrame() const;

    f32 GetAnimationFrameMax() const;

protected:
    void GetAnimTagNameFromAnimFileName(
        ut::BufferedSafeString* dst,
        const ut::SafeString& src);

    enum
    {
        cAnimFileNameMax = lyt::LayoutNameStrMax + lyt::AnimTagNameStrMax + 8,
        cAnimMax = 1024
    };

    lyt::Layout* m_Layout;
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    vwrlyt::DirResourceAccessor* m_ResourceAccessor;
#elif defined(NW_PLATFORM_CAFE)
    vwrlyt::FindableArcResourceAccessor* m_ResourceAccessor;
#endif

    struct AnimInfo
    {
        ut::FixedSafeString<cAnimFileNameMax> name;
        int tagOrder;

        AnimInfo()
            : tagOrder(0)
        {}

        static bool compareTagOrder(const AnimInfo& a, const AnimInfo& b)
        {
            return a.tagOrder < b.tagOrder;
        }
    };

    u32 m_AnimationNum;
    u32 m_CurrentAnimationNo;
    ut::FixedSafeString<lyt::AnimTagNameStrMax> m_CurrentAnimationName;
    TargetMode m_TargetMode;
    lyt::AnimResource m_CurrentAnimResource;
    u32 m_CurrentTargetNo;
    const char* m_CurrentTargetName;
    lyt::Animator* m_Animator;
    u32 m_LayoutNameLength;
    ut::FixedSizeArray<AnimInfo, cAnimMax> mAnimInfoArray;
};

} // namespace vwrlyt
} // namespace nw

#endif // NW_VWRLYT_ENABLE
#endif
