﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_VWRLYT_ALL_PANE_ANIMATOR_H_
#define NW_VWRLYT_ALL_PANE_ANIMATOR_H_

#include <nw/vwrlyt/vwrlyt_Config.h>
#if defined(NW_VWRLYT_ENABLE)

#include <nw/lyt.h>

namespace nw
{
namespace vwrlyt
{

//---------------------------------------------------------------------------
//! @brief 指定されたレイアウトの中で、アニメタグにキーが含まれている全てのペインをアニメーションさせるAnimatorです。
//!
//! @since 2010/12/2 初版。
//---------------------------------------------------------------------------
class AllPaneAnimator : public lyt::Animator
{
public:
    AllPaneAnimator()
     : lyt::Animator()
     , m_Layout(NULL)
    {}

    /**
     *	@brief 指定されたレイアウトの中で、アニメタグにキーが含まれている全てのペインにバインドし、
     *	       内部にレイアウトのポインタを保持します。
     *
     *  @param[in,out] layout    ペインをバインドしたいレイアウト
     *  @param[in] enable        開始時にアニメを有効状態にするか
     */
    void Setup(lyt::Layout* layout, bool enable);

    /**
     *  @brief Setupで関連付けたアニメーションをバインド解除します。
     */
    virtual void Unbind();

protected:
    lyt::Layout* m_Layout;      //! 関連づけられたレイアウト

};

} // namespace vwrlyt
} // namespace nw

#endif // NW_VWRLYT_ENABLE
#endif
