﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_UT_H_
#define NW_UT_H_

/*!
  @namespace  nw::ut
  @brief      ユーティリティライブラリの名前空間です。
*/


#include <nw/config.h>

#include <nw/ut/ut_Config.h>

#include <nw/ut/ut_BinaryFileFormat.h>
#include <nw/ut/ut_BinaryReader.h>
#include <nw/ut/ut_BitFlag.h>
#include <nw/ut/ut_BitSet.h>
#include <nw/ut/ut_Children.h>
#include <nw/ut/ut_Flag.h>
#include <nw/ut/ut_Inlines.h>
#include <nw/ut/ut_Iterator.h>
#include <nw/ut/ut_LinkList.h>
#include <nw/ut/ut_List.h>
#include <nw/ut/ut_RuntimeTypeInfo.h>
#include <nw/ut/ut_Float.h>
#include <nw/ut/ut_Foreach.h>
#include <nw/ut/ut_FrameHeap.h>
#include <nw/ut/ut_HeapBase.h>
#include <nw/ut/ut_Memory.h>
#include <nw/ut/ut_MemoryAllocator.h>
#include <nw/ut/ut_MoveArray.h>
#include <nw/ut/ut_MovePtr.h>
#include <nw/ut/ut_SharedPtr.h>
#include <nw/ut/ut_Signal.h>
#include <nw/ut/ut_String.h>
#include <nw/ut/ut_SafeString.h>
#include <nw/ut/ut_TypeTraits.h>
#include <nw/ut/ut_Preprocessor.h>
#include <nw/ut/ut_LockObject.h>
#include <nw/ut/ut_ScopedLock.h>

#include <nw/ut/ut_Color.h>
#include <nw/ut/ut_Rect.h>
#include <nw/ut/res/ut_ResTypes.h>
#include <nw/ut/res/ut_ResTypeInfo.h>
#include <nw/ut/ut_Result.h>

#include <nw/ut/ut_IoStream.h>
#include <nw/ut/ut_FileStream.h>
#include <nw/ut/ut_FsFileStream.h>
#include <nw/ut/ut_MemoryFileStream.h>

#include <nw/ut/os/ut_Print.h>
#include <nw/ut/os/ut_Mutex.h>
#include <nw/ut/os/ut_SpinLock.h>
#include <nw/ut/os/ut_CriticalSection.h>
#include <nw/ut/os/ut_Event.h>
#include <nw/ut/os/ut_Thread.h>
#include <nw/ut/os/ut_MessageQueue.h>
#include <nw/ut/os/ut_Time.h>

#if !defined(NW_UT_RES_SWAP_ENDIAN) // 正しく動作しない

#include <nw/ut/res/ut_ResDictionary.h>
#include <nw/ut/res/ut_ResArray.h>
#include <nw/ut/res/ut_ResDeclMacros.h>
#include <nw/ut/res/ut_ResMetaData.h>
#include <nw/ut/res/ut_ResUtil.h>
#include <nw/ut/res/ut_ResPrimitive.h>

#endif

/* NW_UT_H_ */
#endif
