﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_FND_STRING_H_
#define NW_SND_SPY_FND_STRING_H_

#include <cstring>
#include <cstdarg>
#include <stdio.h>
#include <stdarg.h>
#include <nw/snd/spy/fnd/basis/sndspyfnd_Inlines.h>

namespace nw {
namespace snd {
namespace spy {
namespace internal {
namespace fnd {

//---------------------------------------------------------------------------
//! @brief    文字列を操作、管理します。
//!
//! @details  HACK : このクラスは実装途中です。
//!                  必要になった機能だけを随時実装していきます。
//---------------------------------------------------------------------------
class String
{
private:
    // 現状はインスタンス生成できる意味がないので禁止します。
    String() { }

public:
    //! @brief 文字列をコピーします。
    //! コピー先の文字列は必ずヌル文字で終端されます。
    //! @param[in] buffer コピー先です。
    //! @param[in] bufferLength コピー先に格納可能な文字数です。終端のヌル文字を含みます。
    //! @param[in] src コピー元です。
    static void Copy(char* buffer, u32 bufferLength, const char* src);

    static NW_INLINE int
    Vsnprintf(char* buffer, std::size_t bufferLength, std::size_t strCount, const char* format, va_list vargs)
    {
#if defined(NW_COMPILER_MSVC)
//#pragma warning(push)
//#pragma warning(disable : 4996)
#endif

#if defined(NW_COMPILER_MSVC)
        int result = ::vsnprintf_s( buffer, bufferLength, strCount, format, vargs );
#elif defined(NW_COMPILER_GHS)
        int result = ::vsnprintf( buffer, Min(bufferLength, strCount + 1), format, vargs );
#else
        int result = std::vsnprintf( buffer, strCount, format, vargs );
#endif

        buffer[bufferLength - 1] = '\0';

        return result;

#if defined(NW_COMPILER_MSVC)
//#pragma warning(pop)
#endif
    }

    //---------------------------------------------------------------------------
    static NW_INLINE int
    Vsnprintf(char* buffer, std::size_t bufferLength, const char* format, std::va_list vlist)
    {
        return Vsnprintf(buffer, bufferLength, bufferLength - 1, format, vlist);
    }
};

} // namespace nw::snd::spy::internal::fnd
} // namespace nw::snd::spy::internal
} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_SPY_FND_STRING_H_

