﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_FND_EVENT_IMPL_CAFE_H_
#define NW_SND_SPY_FND_EVENT_IMPL_CAFE_H_

#include <nw/snd/snd_Config.h>
#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/snd/spy/fnd/os/sndspyfnd_Event.h>

namespace nw {
namespace snd {
namespace spy {
namespace internal {
namespace fnd {

//---------------------------------------------------------------------------
NW_INLINE
Event::Event(bool isManual, bool isInitialState) :
m_IsInitialized(false)
{
    Initialize(isManual, isInitialState);
}

//---------------------------------------------------------------------------
NW_INLINE
Event::~Event()
{
    Finalize();
}

//---------------------------------------------------------------------------
NW_INLINE
void
Event::Wait()
{
    NW_ASSERT(m_IsInitialized);
    OSWaitEvent(&m_Event);
}

//---------------------------------------------------------------------------
NW_INLINE
bool
Event::TryWait()
{
    NW_ASSERT(m_IsInitialized);
    return OSWaitEventWithTimeout(&m_Event, 0) == TRUE;
}

//---------------------------------------------------------------------------
NW_INLINE
void
Event::Set()
{
    NW_ASSERT(m_IsInitialized);
    OSSignalEvent(&m_Event);
}

//---------------------------------------------------------------------------
NW_INLINE
void
Event::Reset()
{
    NW_ASSERT(m_IsInitialized);
    OSResetEvent(&m_Event);
}

//---------------------------------------------------------------------------
NW_INLINE
void
Event::Initialize(bool isManual, bool isInitialState)
{
    if(m_IsInitialized)
    {
        return;
    }

    OSInitEvent(&m_Event, isInitialState, isManual);
    m_IsInitialized = true;
}

//---------------------------------------------------------------------------
NW_INLINE
void
Event::Finalize()
{
    m_IsInitialized = false;
}

} // namespace nw::snd::spy::internal::fnd
} // namespace nw::snd::spy::internal
} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV

#endif // NW_SND_SPY_FND_EVENT_IMPL_CAFE_H_
