﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_FND_BINARY_H_
#define NW_SND_SPY_FND_BINARY_H_

namespace nw {
namespace snd {
namespace spy {
namespace internal {
namespace fnd {

#if defined(NW_SND_SPY_FND_IS_LITTLE_ENDIAN)

#define NW_SND_SPY_FND_BINARY_MAKE_U32_SIGNATURE(a,b,c,d)    \
    static_cast<u32 >(                      \
          (static_cast<u8>(a) <<  0)        \
        | (static_cast<u8>(b) <<  8)        \
        | (static_cast<u8>(c) << 16)        \
        | (static_cast<u8>(d) << 24)        \
    )

#else

#define NW_SND_SPY_FND_BINARY_MAKE_U32_SIGNATURE(a,b,c,d)    \
    static_cast<u32 >(                      \
          (static_cast<u8>(a) << 24)        \
        | (static_cast<u8>(b) << 16)        \
        | (static_cast<u8>(c) <<  8)        \
        | (static_cast<u8>(d) <<  0)        \
    )
#endif

} // namespace nw::snd::spy::internal::fnd
} // namespace nw::snd::spy::internal
} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_SPY_FND_BINARY_H_

