﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_WAV_BINARY_H_
#define NW_SND_WAV_BINARY_H_

#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>

namespace nw {
namespace snd {
namespace internal {

#pragma pack(push, 1)

//---------------------------------------------------------------------------
//! @brief  チャンクヘッダ
//---------------------------------------------------------------------------
struct ChunkHeader
{
    /* ctor */ ChunkHeader() : id(0), size(0) { }

    /* ctor */ ChunkHeader(u32 id) : id(id), size(0) { }

    /* ctor */ ChunkHeader(u32 id, u32 size) : id(id), size(size) { }

    u32 id;
    fnd::PcBinU32 size;
};

//---------------------------------------------------------------------------
//! @brief  RIFF チャンク
//---------------------------------------------------------------------------
struct RiffChunk
{
    static const u32 ValidID = NW_UT_MAKE_SIGWORD('R', 'I', 'F', 'F');

    /* ctor */ RiffChunk() : header(ValidID), formatType(0) { }

    bool IsValid()
    {
        return header.id == ValidID;
    }

    ChunkHeader header;
    u32 formatType;
};

//---------------------------------------------------------------------------
//! @brief  fmt チャンク
//---------------------------------------------------------------------------
struct FmtChunk
{
    static const u32 ValidID = NW_UT_MAKE_SIGWORD('f', 'm', 't', ' ');
    static const u16 FORMAT_PCM = 1;

    /* ctor */ FmtChunk() :
        header(ValidID, GetValidBodySize()),
        formatTag(0),
        channels(0),
        samplesPerSec(0),
        avgBytesPerSec(0),
        blockAlign(0),
        bitsPerSample(0)
    { }

    static u32 GetValidBodySize()
    {
        return sizeof(FmtChunk) - sizeof(ChunkHeader);
    }

    bool IsValid()
    {
        return header.id == ValidID;
    }

    ChunkHeader header;
    fnd::PcBinU16 formatTag;
    fnd::PcBinU16 channels;
    fnd::PcBinU32 samplesPerSec;
    fnd::PcBinU32 avgBytesPerSec;
    fnd::PcBinU16 blockAlign;
    fnd::PcBinU16 bitsPerSample;
};

//---------------------------------------------------------------------------
//! @brief  data チャンク
//---------------------------------------------------------------------------
struct DataChunk
{
    static const u32 ValidID = NW_UT_MAKE_SIGWORD('d', 'a', 't', 'a');

    /* ctor */ DataChunk() : header(ValidID) { }

    bool IsValid()
    {
        return header.id == ValidID;
    }

    ChunkHeader header;
};

//---------------------------------------------------------------------------
//! @brief  WAV バイナリヘッダ
//---------------------------------------------------------------------------
struct WaveBinaryHeader
{
    WaveBinaryHeader()
    {
        riffChunk.formatType = NW_UT_MAKE_SIGWORD('W', 'A', 'V', 'E');
    }

    RiffChunk riffChunk;
    FmtChunk fmtChunk;
    DataChunk dataChunk;
};

#pragma pack(pop)

} // internal
} // snd
} // nw

#endif // NW_SND_WAV_BINARY_H_
