﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_BANK_FILE_READER_H_
#define NW_SND_BANK_FILE_READER_H_

#include <nw/snd/snd_Global.h>      // AdshrCurve
#include <nw/snd/snd_BankFile.h>

namespace nw {
namespace snd {
namespace internal {

struct VelocityRegionInfo
{
    u32 waveArchiveId;      // 波形アーカイブ ID
    u32 waveIndex;          // 波形アーカイブ内インデックス

    f32 pitch;              // NW4R では tune という名前だった
    AdshrCurve adshrCurve;

    u8 originalKey;
    u8 volume;
    u8 pan;
#ifdef NW_PLATFORM_RVL
    u8 surroundPan;
#endif /* NW_PLATFORM_RVL */
    bool isIgnoreNoteOff;   // true: ノートオフを無視する (＝パーカッションモード)
    u8 keyGroup;
    u8 interpolationType;
};

class BankFileReader
{
public:
    static const u32 SIGNATURE_FILE = NW_UT_MAKE_SIGWORD( 'F', 'B', 'N', 'K' );

    BankFileReader();
    explicit BankFileReader( const void* bankFile );
    void Initialize( const void* bankFile );
    void Finalize();

    bool IsInitialized() const { return m_IsInitialized; }

    bool ReadVelocityRegionInfo(
            VelocityRegionInfo* info,
            int programNo,
            int key,
            int velocity
    ) const;

    const Util::WaveIdTable* GetWaveIdTable() const;
    const void* GetBankFileAddress() const { return m_pHeader; }

    // デバッグ用
    int GetInstrumentCount() const
    {
        if ( m_IsInitialized == false )
        {
            return 0;
        }
        return m_pInfoBlockBody->GetInstrumentCount();
    }

private:
    const BankFile::FileHeader*     m_pHeader;
    const BankFile::InfoBlockBody*  m_pInfoBlockBody;
    bool m_IsInitialized;
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_BANK_FILE_READER_H_ */

