﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_AXFX_IMPL_H_
#define NW_SND_AXFX_IMPL_H_

#include <nw/types.h>

#if defined( NW_PLATFORM_CAFE )
  #include <cafe/axfx.h>
  #include <cafe/mem.h>
#elif defined( NW_PLATFORM_WIN32 )
  #include <winext/cafe/axfx.h>
  #include <winext/cafe/mem.h>
#elif defined( NW_USE_NINTENDO_SDK )
  // TODO: nn_audio nn_os
  #include <winext/cafe/axfx.h>
  #include <winext/cafe/mem.h>
#endif

#include <nw/snd/snd_Config.h>

namespace nw {
namespace snd {
namespace internal {

/* ========================================================================
        class difinition
   ======================================================================== */

class AxfxImpl
{
  public:
#if defined( NW_PLATFORM_WIN32 )
    typedef nw::internal::winext::AXFXAlloc AXFXAlloc;
    typedef nw::internal::winext::AXFXFree AXFXFree;
#elif defined( NW_PLATFORM_ANDROID ) || defined( NW_PLATFORM_IOS )
    typedef nw::internal::winext::AXFXAlloc AXFXAlloc;
    typedef nw::internal::winext::AXFXFree AXFXFree;
#elif defined(NW_USE_NINTENDO_SDK)
    // TODO: nn_audio
    typedef nw::internal::winext::AXFXAlloc AXFXAlloc;
    typedef nw::internal::winext::AXFXFree AXFXFree;
#endif

    AxfxImpl() : m_Handle( MEM_HEAP_INVALID_HANDLE ), m_AllocCount( 0 ) {}
    bool CreateHeap( void *buffer, u32 size );
    void DestroyHeap();
    s32 GetHeapTotalSize()
    {
        return ( m_Handle == MEM_HEAP_INVALID_HANDLE) ? 0 : MEMGetHeapTotalSize( m_Handle );
    }

    // AXFX***Init, AXFX***Finalize前に呼び出す
    void HookAlloc( AXFXAlloc* alloc, AXFXFree* free );
#if defined(NW_SND_CONFIG_ENABLE_MULTICHEFT) && !defined(NW_SND_CONFIG_ENABLE_SOUND2)
    void HookMultichAlloc( AXFXAlloc* alloc, AXFXFree* free );
#endif
    // AXFX***Init, AXFX***Finalize後に呼び出す
    u32 RestoreAlloc( AXFXAlloc alloc, AXFXFree free );
#if defined(NW_SND_CONFIG_ENABLE_MULTICHEFT) && !defined(NW_SND_CONFIG_ENABLE_SOUND2)
    u32 RestoreMultichAlloc( AXFXAlloc alloc, AXFXFree free );
#endif

  private:
#if defined( NW_PLATFORM_WIN32 )
    typedef nw::internal::winext::MEMHeapHandle MEMHeapHandle;
#elif defined( NW_PLATFORM_ANDROID ) || defined( NW_PLATFORM_IOS )
    typedef nw::internal::winext::MEMHeapHandle MEMHeapHandle;
#elif defined(NW_USE_NINTENDO_SDK)
    // TODO: nn_os
    typedef nw::internal::winext::MEMHeapHandle MEMHeapHandle;
#endif // defined( NW_PLATFORM_WIN32 )

    MEMHeapHandle m_Handle;
    u32 m_AllocCount;
    static AxfxImpl* m_pCurrentFx;
    static u32 m_AllocatedSize;

    static void* Alloc( u32 size );
    static void  Free( void* ptr );
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

#endif /* NW_SND_AXFX_IMPL_H_ */
