﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * :include nw/snd/snd_Adpcm.h
 *
 * @file snd_Adpcm.h
 */

#ifndef NW_SND_ADPCM_H_
#define NW_SND_ADPCM_H_

#if defined(__APPLE__)
#include <TargetConditionals.h>
#endif

// Cafe SDK の types.h から移植
#if defined( _WIN32 )
    typedef __int16             s16;
    typedef __int32             s32;
    typedef unsigned __int8      u8;
    typedef unsigned __int16    u16;
    typedef unsigned __int32    u32;
#elif defined( ANDROID ) || defined(__APPLE__)
// TODO: 現状 TARGET_OS_IPHONE はトリミングできないため __APPLE__ を使用しています。
    typedef int16_t             s16;
    typedef int32_t             s32;
    typedef uint8_t             u8;
    typedef uint16_t            u16;
    typedef uint32_t            u32;
#elif defined( CAFE )
    typedef signed short        s16;
    typedef signed int          s32;
    typedef unsigned char        u8;
    typedef unsigned short      u16;
    typedef unsigned int        u32;
#else
    #error "Unknown platform"
#endif


namespace nw {
namespace snd {

/*!
    @brief  Adpcm の係数を格納する構造体です。
    @date   2011/07/07 NW4F 1.0.0 PR 公開に向けた調整
*/
struct AdpcmParam
{
    u16 coef[8][2]; //!< Adpcm の係数
}; // AdpcmParam


// (TODO: Voice の公開時に、これも公開する)
/*!
    @briefprivate
    @brief  Adpcm のコンテクストを格納する構造体です。
    @date   2011/07/07 NW4F 1.0.0 PR 公開に向けた調整
*/
struct AdpcmContext
{
    u16 pred_scale; //!< Adpcm の予測値（4bit）、スケール値（4bit）を格納します。上位8 ビットは参照されません。
    s16 yn1;        //!< 履歴データ（1 つ前のサンプル値）
    s16 yn2;        //!< 履歴データ（2 つ前のサンプル値）
};

} // namespace nw::snd
} // namespace nw

#endif /* NW_SND_ADPCM_H_ */

