﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_FND_HIO_IO_STREAM_H_
#define NW_SND_FND_HIO_IO_STREAM_H_

#include <nw/config.h>

#if defined(NW_PLATFORM_CTR)
#include <nn/hio.h>
#elif defined(NW_PLATFORM_CAFE)
#include <cafe/hio.h>
#endif

#if defined(NW_PLATFORM_CTR)
#include <nw/io/io_IOStream.h>
#else
#include <nw/ut/ut_IoStream.h>
#endif

#include <nw/ut/ut_Inlines.h>
#include <nw/snd/fnd/basis/sndfnd_Config.h>
#include <nw/snd/fnd/basis/sndfnd_Result.h>
#include <nw/snd/fnd/io/sndfnd_SimpleRingBuffer.h>

#if defined(NW_PLATFORM_CTR)
#if NN_CURRENT_VERSION_NUMBER >= NN_VERSION_NUMBER(4,0,0,0)
#pragma diag_suppress 1301 // padding inserted in struct.
#pragma diag_suppress 2530 // padding added to end of struct.
#endif
#endif

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

#if defined(NW_PLATFORM_CTR)
typedef nw::io::IOStream IoStream;
#else
typedef nw::ut::IoStream IoStream;
#endif

//---------------------------------------------------------------------------
//! @brief  HIO入出力ストリームのクラスです。
//---------------------------------------------------------------------------
class HioStream : public IoStream
{
public:
#if defined(NW_PLATFORM_CTR)
typedef u32 ChannelType;
#elif defined(NW_PLATFORM_CAFE)
typedef const char* ChannelType;
#else
typedef u32 ChannelType;
#endif

    NW_DISALLOW_COPY_AND_ASSIGN(HioStream);

public:
    HioStream();
    virtual ~HioStream();

    void Initialize(void* workBuffer, u32 workBufferLength);
    void Finalize();

    bool Open(ChannelType channel, void* buffer, u32 length);
    void OpenImpl(ChannelType channel);
    virtual void Close();
    void CloseImpl();

    virtual s32 Read(void* buffer, u32 length);
    s32 Peek(void* buffer, u32 length);
    s32 Skip(u32 length);
    virtual s32 Write(const void* buffer, u32 length);
    s32 WriteImpl(const void* buffer, u32 length);

    bool Connect();
    void Disconnect();

    bool IsOpened() const { return m_IsOpened; }
    virtual bool IsAvailable() const;
    ChannelType GetChannel() const { return m_Channel; }

    u32 GetReadableBytes();
    u32 GetWritableBytes() const;

    virtual bool CanAsync() const { return false; }
    virtual bool CanRead() const { return IsAvailable(); }
    virtual bool CanWrite() const { return IsAvailable(); }

#if defined(NW_PLATFORM_CAFE)
    static void ConnectionCallback(HIOStatus status, void* context);
    static void ReadBufferFinishedCallback(HIOStatus status, void* context);
#endif

private:
    void ReadBuffer();
#if defined(NW_PLATFORM_CTR)
    bool ProcessResult(nn::Result result);
#endif

private:
    bool m_IsOpened;
    ChannelType m_Channel;

    SimpleRingBuffer m_RingBuffer;
    void* m_WorkBuffer;
    u32 m_WorkBufferLength;
    u32 m_ReadSize;

#if defined(NW_PLATFORM_CAFE)
    HIOHandle m_HioHandle;
    //OSEvent m_ConnectEvent;
    volatile bool m_IsReading;
    volatile bool m_IsAvailable;
#elif defined(NW_PLATFORM_WIN32) || defined(NW_PLATFORM_ANDROID)
    uptr m_Socket;
    uptr m_ClientSocket;
#elif defined(NW_USE_NINTENDO_SDK)
    // TODO: nn_htcs
    uptr m_Socket;
    uptr m_ClientSocket;
#elif defined(NW_PLATFORM_CTR)
    nn::hio::SerialChannel m_Stream;
    void* m_HioWorkBuffer;
    bool m_IsConnect;
    bool m_IsRunning;
#endif
};

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

#if defined(NW_PLATFORM_CTR)
#if NN_CURRENT_VERSION_NUMBER >= NN_VERSION_NUMBER(4,0,0,0)
#pragma diag_default 1301 // padding inserted in struct.
#pragma diag_default 2530 // padding added to end of struct.
#endif
#endif

#endif // NW_SND_FND_HIO_IO_STREAM_H_
