﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_EDIT_SOUND_ARCHIVE_PARAMETER_EDITOR_H_
#define NW_SND_EDIT_SOUND_ARCHIVE_PARAMETER_EDITOR_H_

#include <nw/snd/snd_Config.h>
#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/snd/snd_SoundArchiveParametersHook.h>
#include <nw/snd/edit/sndedit_Result.h>
#include <nw/snd/edit/res/sndedit_ResItemInfo.h>

namespace nw {
namespace snd {

class SoundArchive;

namespace edit {
namespace internal {

class SoundArchiveEditController;
class ResourceManager;

//---------------------------------------------------------------------------
//! @brief    サウンドアーカイブのパラメータ編集機能を提供するクラスです。
//---------------------------------------------------------------------------
class SoundArchiveParameterEditor
{
    NW_DISALLOW_COPY_AND_ASSIGN(SoundArchiveParameterEditor);

public:
    //! @brief  サウンドアーカイブのパラメータアクセスをフックし、パラメータを指し替えます。
    class Hook : public snd::internal::SoundArchiveParametersHook
    {
        NW_DISALLOW_COPY_AND_ASSIGN(Hook);

    public:
        explicit Hook() : m_Owner(NULL) { }

    public:
        void Initialize(SoundArchiveParameterEditor& owner)
        {
            m_Owner = &owner;
        }

    protected:
        //---------------------------------------------------------------------------
        //! @brief         指定アイテムラベルがフック対象かどうかを調べます。
        //!
        //! @param[in]     itemLabel     アイテムラベルを指定します。
        //!
        //! @return        対象の場合は true、対象でない場合は false を返します。
        //---------------------------------------------------------------------------
        virtual bool IsTargetItemImpl(const char* itemLabel);

        virtual const char* GetItemLabelImpl(SoundArchive::ItemId id) const;
        virtual SoundArchive::ItemId GetItemIdImpl(const char* itemLabel) const;

        virtual SoundArchive::SoundType GetSoundTypeImpl(const char* itemLabel);

        virtual bool ReadSoundInfoImpl(
            SoundArchive::ItemId soundId,
            SoundArchive::SoundInfo* info ) const;
        virtual bool ReadSoundInfoImpl(
            const char* soundName,
            SoundArchive::SoundInfo* info ) const;
        virtual bool ReadSound3DInfoImpl(
            SoundArchive::ItemId soundId,
            SoundArchive::Sound3DInfo* info ) const;
        virtual bool ReadSound3DInfoImpl(
            const char* soundName,
            SoundArchive::Sound3DInfo* info ) const;
        virtual bool ReadSequenceSoundInfoImpl(
            SoundArchive::ItemId soundId,
            SoundArchive::SequenceSoundInfo* info ) const;
        virtual bool ReadSequenceSoundInfoImpl(
            const char* soundName,
            SoundArchive::SequenceSoundInfo* info ) const;
        virtual bool ReadStreamSoundInfoImpl(
            SoundArchive::ItemId soundId,
            SoundArchive::StreamSoundInfo* info ) const;
        virtual bool ReadStreamSoundInfoImpl(
            const char* soundName,
            SoundArchive::StreamSoundInfo* info ) const;
        virtual bool ReadStreamSoundInfo2Impl(
            SoundArchive::ItemId soundId,
            SoundArchive::StreamSoundInfo2* info ) const;
        virtual bool ReadStreamSoundInfo2Impl(
            const char* soundName,
            SoundArchive::StreamSoundInfo2* info ) const;
        virtual bool ReadWaveSoundInfoImpl(
            SoundArchive::ItemId soundId,
            SoundArchive::WaveSoundInfo* info ) const;
        virtual bool ReadWaveSoundInfoImpl(
            const char* soundName,
            SoundArchive::WaveSoundInfo* info ) const;
        virtual bool ReadSoundUserParamImpl(
            SoundArchive::ItemId soundId,
            int index,
            u32& value) const;
        virtual bool ReadSoundUserParamImpl(
            const char* soundName,
            int index,
            u32& value) const;
        virtual u32 GetSoundUserParamImpl(
            SoundArchive::ItemId soundId,
            u32 userParam) const;
        virtual u32 GetSoundUserParamImpl(
            const char* soundName,
            u32 userParam) const;

    private:
        inline const char* GetItemName(SoundArchive::ItemId itemID) const;

        bool IsValidDataType(SoundArchive::SoundType soundType, ResDataType dataType) const;

        SoundArchive::SoundType ResDataTypeToSoundType(ResDataType dataType) const;

    private:
        SoundArchiveParameterEditor* m_Owner;
    };

public:
    SoundArchiveParameterEditor();
    ~SoundArchiveParameterEditor() {}

public:
    //! @brief  初期化します。
    //! @param editController TBD
    //! @param resourceManager TBD
    //! @param soundArchive TBD
    //! @return TBD
    Result Initialize(
        SoundArchiveEditController* editController,
        ResourceManager* resourceManager,
        SoundArchive* soundArchive);

    //! @brief  終了処理を行います。
    void Finalize();

    bool IsInitialized() const { return m_SoundArchive != NULL; }

    //! @brief  パラメータ編集を開始します。
    void Start();

    //! @brief  パラメータ編集を終了します。
    void Stop();

private:
    Hook                        m_SoundArchiveHook;
    SoundArchiveEditController* m_SoundArchiveEditController;
    ResourceManager*            m_ResourceManager;
    SoundArchive*               m_SoundArchive;
};

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV

#endif // NW_SND_EDIT_SOUND_ARCHIVE_PARAMETER_EDITOR_H_
