﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_DW_SOUND_WINDOW_H_
#define NW_SND_DW_SOUND_WINDOW_H_

#include <nw/dw/window/dw_ControlWindow.h>
#include <nw/snd/dw/system/snddw_Allocator.h>

namespace nw {
namespace internal {
namespace dw {
    class UIRenderer;
    class WindowContext;
}
}
}

namespace nw {
namespace snd {
namespace dw {

//---------------------------------------------------------------------------
//! @briefprivate
//---------------------------------------------------------------------------
class SoundWindow : public nw::internal::dw::ControlWindow
{
public:
    //---------------------------------------------------------------------------
    //! @briefprivate
    //---------------------------------------------------------------------------
    struct SetupArg
    {
        void* fontBinary;
        u32 fontBinarySize;
        void* fontShaderBinary;
        u32 fontShaderBinarySize;
        nw::math::Matrix44* projectionMatrix;
        nw::math::Matrix34* viewMatrix;
    };

public:
    //! @name コンストラクタ/デストラクタ
    //@{
    //---------------------------------------------------------------------------
    //! @brief    デストラクタです。
    //!
    //! @date 2012/02/15 初版
    //---------------------------------------------------------------------------
    SoundWindow();

    //---------------------------------------------------------------------------
    //! @brief    デストラクタです。
    //!
    //! @date 2012/02/15 初版
    //---------------------------------------------------------------------------
    virtual ~SoundWindow();
    //@}

public:
    //! @name 初期化
    //@{
    //---------------------------------------------------------------------------
    //! @brief    ウィンドウの開始処理を行います。
    //!
    //! @param memory     ウィンドウに割り当てるメモリの先頭アドレスです。
    //! @param memorySize 割り当てるメモリサイズです。
    //!
    //! @date 2012/02/15 初版
    //---------------------------------------------------------------------------
    void Initialize(void* memory, u32 memorySize);

    //---------------------------------------------------------------------------
    //! @brief    ウィンドウの終了処理を行います。
    //!
    //! @date 2012/02/15 初版
    //---------------------------------------------------------------------------
    void Finalize();

    //! @briefprivate
    //! @param arg :private
    void Setup(const SetupArg arg);
    //@}

    //! @name 取得/設定
    //@{
public:
    //---------------------------------------------------------------------------
    //! @brief    タイトルを設定します。
    //!
    //! @param title 設定するタイトルです。
    //!
    //! @date 2012/02/15 初版
    //---------------------------------------------------------------------------
    void SetTitle(const char* title);

    //---------------------------------------------------------------------------
    //! @brief    SoundWindow を１つ作るのに必要なメモリサイズを取得します。
    //!
    //! @return   メモリサイズ(バイト)を返します。
    //!
    //! @date 2012/02/15 初版
    //---------------------------------------------------------------------------
    virtual u32  GetRequiredSize() const = 0;
    //@}

protected:
    //! @briefprivate
    virtual void OnInitialize() { }

    //! @briefprivate
    virtual void OnFinalize() { }

    //! @briefprivate
    //! @param context :private
    //! @param renderer :private
    //! @param alpha :private
    //! @param isShade :private
    virtual void DrawImpl(nw::internal::dw::WindowContext& context, nw::internal::dw::UIRenderer& renderer, float alpha, bool isShade);

    //! @briefprivate
    //! @param size :private
    //! @param alignment :private
    //! @return :private
    void* Alloc(size_t size, u32 alignment = 0);

    //! @briefprivate
    //! @param memory :private
    void Free(void* memory);

private:
    internal::Allocator m_Allocator;
    nw::internal::dw::NwUIRenderer m_UIRenderer;
    nw::internal::dw::NwTextRenderer m_TextRenderer;
};

} // namespace dw
} // namespace snd
} // namespace nw

#endif // NW_SND_DW_SOUND_WINDOW_H_
